local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


aom_longship = {}

aom_longship.has_aom_tcraft = (minetest.get_modpath("aom_tcraft") ~= nil)
aom_longship.has_aom_settings = (minetest.get_modpath("aom_settings") ~= nil)

if aom_longship.has_aom_settings then
    aom_settings.register_setting("longship_can_place_land", true, "Can place ships on land", "server")
    aom_settings.register_setting("longship_max_speed_multiplier", 1, "Speed multiplier at max wind", "server")
    aom_settings.register_setting("longship_min_speed_multiplier", 1, "Speed multiplier at no wind", "server")
end

function aom_longship.get_setting(player, name, default)
    if aom_longship.has_aom_settings then return aom_settings.get_setting(player, name) or default
    else return default end
end

dofile(mod_path .. "/entity.lua")
