
aer_itemdesc.colors = {
	gold = "#ffe478",
	blue = "#7391ff",
	red = "#e9203e",
	purple = "#bb1e72",
	white = "#ffffff",
	black = "#000000",
	darkblue = "#232130",
	whitelow = "#aeaeae",
	grey = "#999999",
}

local registered_tooltips = {}
function aer_itemdesc.register_tooltip(callback, priority)
	if priority then -- allow cutting the queue
		priority = math.max(math.min(priority, #registered_tooltips), 1)
		table.insert(registered_tooltips, priority, callback)
	else
		table.insert(registered_tooltips, callback)
	end
end

local ignored_items = {
	["air"] = true,
	["ignore"] = true,
	["unknown"] = true,
}

local function override_all_items()
	for itemname, def in pairs(minetest.registered_items) do repeat
		if (not itemname) or (itemname == "") or ignored_items[itemname] then break end
		if def._tt_ignore then break end

		local desc = ""
		local old_desc = def.description

        local no_linebreak = true
		for i, callback in ipairs(registered_tooltips) do
			local snippet, color = callback(itemname, def)
			if snippet then
				if color then
					snippet = minetest.colorize(color, snippet)
				end
				desc = desc .. (no_linebreak and "" or "\n") .. snippet
                no_linebreak = false
			end
		end

		minetest.override_item(itemname, {
			description = desc,
			_tt_original_description = old_desc
		})
	until true end
end

minetest.register_on_mods_loaded(override_all_items)
