local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local pipe_box1 = nil
local pipe_box = nil
if true then
    local pw = 6/16 -- width
    local pl = 8/16 -- length
    local pa = 4/16 -- length
    pipe_box1 = {
        type = "fixed",
        fixed = {
            -pa, -pa, -pa,
             pa,  pa,  pa
        },
    }
    pipe_box = {
        type = "connected",
        fixed = {
            -- {
            --     -pw*2,  pw-2/16, -pw*2,
            --      pw*2,  pw,       pw*2
            -- },
            {
                -pa, -pa, -pa,
                 pa,  pa,  pa
            },
        },
        connect_top = {
            -pw,  pl-4/16, -pw,
             pw,  pl,  pw
        },
        connect_bottom = {
            -pw, -pl, -pw,
             pw, -pl+4/16,  pw
        },
        connect_front = {
            -pw, -pw, -pl,
             pw,  pw, -pl+4/16
        },
        connect_left = {
            -pl, -pw, -pw,
            -pl+4/16,  pw,  pw
        },
        connect_back = {
            -pw, -pw,  pl-4/16,
             pw,  pw,  pl
        },
        connect_right = {
             pl-4/16, -pw, -pw,
             pl,  pw,  pw
        },
    }
end

local function get_filter(pos)
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    local out = {}
    local size = inv:get_size("filter")
    for i=1, size do
        local stack = inv:get_stack("filter", i)
        if not stack:is_empty() then
            out[#out+1] = stack:get_name()
        end
    end
    return out
end


local function get_formspec()
    local fs, size = aom_inventory.player.get_formspec(nil)
    local y = 12-size.y-2
    return table.concat({
        fs,
        aom_inventory.get_9patch(8, y-3.5, 6, 4, aom_inventory.get_bg9patch_texture("#8e6e59"), "false", "32"),
        "image[10.2,"..tostring(y-2)..";2,1;aom_pipes_text_filter.png]",
        ((aom_inventory.get_itemslot_array(8.5, y-1, 5, 1, nil, "#534")) or ""),
        "list[context;filter;8.5,"..tostring(y-1)..";5,1;]",
        ((aom_inventory.get_itemslot_array(10.5, y-3, 1, 1)) or ""),
        "list[context;main;10.5,"..tostring(y-3)..";1,1;]",
        "listring[context;main]",
        "listring[current_player;main]"
    })
end

local function fix_formspec(pos)
    -- set up the formspec and stuff
    local meta = minetest.get_meta(pos)
    local formspec = get_formspec()
    if meta:get_string("formspec") == formspec then return end
    local inv = meta:get_inventory()
    inv:set_size("filter", 5)
    inv:set_size("main", 1)
    meta:set_string("formspec", formspec)
    meta:set_string("infotext", "Siphon");
    return true
end

minetest.register_node('aom_pipes:siphon', {
    description = S("Pipe Siphon"),
    _tt_color = 3,
    _tt_long_desc = S("Takes items from any \"main\" inventory behind it if they match the filter,"..
        "and then puts them in the pipe or inventory it's facing."),
    groups = { cracky = 1, oddly_breakable_by_hand = 2, solid = 1, mechanisms = 1, suffocates = 0, pipe = 1, siphon = 1},
    tiles = {
        "aom_pipes_siphon_top.png^[transformFY",
        "aom_pipes_siphon_top.png",
        "aom_pipes_siphon_top.png^[transformR90",
        "aom_pipes_siphon_top.png^[transformR270",
        "aom_pipes_siphon.png",
        "aom_pipes_siphon.png",
    },
    -- tiles = {"aom_pipes_siphon.png", "aom_pipes_siphon.png", "aom_pipes_siphon_top.png", "aom_pipes_siphon_top.png",},
    sounds = aom_sounds.default_wood(),
    paramtype = "light",
    sunlight_propagates = true,
    paramtype2 = "facedir",
    drawtype = "nodebox",
    node_box = pipe_box,
    connects_to = { "group:pipe", "group:storage", "group:chest", "group:cooker" },
    collision_box = pipe_box1,
    selection_box = pipe_box1,
    on_place = aom_util.rotate_and_place_against,
    on_timer = function(pos, elapsed)
        local metavec = aom_pipes.get_dir_of_node(pos)
        local to_pos = vector.add(pos, metavec)
        local from_pos = vector.subtract(pos, metavec)
        if (not to_pos) or (not pos) then return true end
        local filter = get_filter(pos)
        if #filter == 0 then filter = nil end
        local ret = false
        ret = aom_pipes.move_item_to(pos, to_pos, aom_pipes.item_move_count, {filter = filter}) or ret
        ret = aom_pipes.move_item_to(from_pos, pos, aom_pipes.item_move_count, {filter = filter}) or ret

        if not ret then
            ret = aom_pipes.suck_up_items(from_pos, pos, aom_pipes.item_move_count, {filter = filter})
        end

        -- siphon must be always active
        return true
    end,
    on_construct = function(pos)
        -- tell the game what node it's pointing into
        local node = minetest.get_node(pos)
        local dir = minetest.facedir_to_dir(node.param2)
        aom_pipes.set_meta_vector(pos, dir)
        fix_formspec(pos)
        -- start the timer
        minetest.get_node_timer(pos):start(1.0)
    end,
        on_destruct = function(pos)
        aom_inventory.drop_contents(pos)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        fix_formspec(pos)
    end,
    _on_node_update = function(pos)
        local nt = minetest.get_node_timer(pos)
        if not nt:is_started() then
            nt:start(1.0)
        end
    end,
    on_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
        aom_pipes.start_timer(pos)
    end,
    on_metadata_inventory_put = function(pos, listname, index, stack, player)
        aom_pipes.start_timer(pos)
    end,
    on_metadata_inventory_take = function(pos, listname, index, stack, player)
        aom_pipes.start_timer(pos)
    end,
    _has_formspec = true,
})

if true then
    local p = "aom_pipes:pipe"
    local d = "aom_pipes:distributor"
    minetest.register_craft({
        output = "aom_pipes:siphon 1",
        recipe = {
            {"aom_items:iron_sheet"},
            {d},
        },
    })
end
