
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = "siera"
local these_biomes = {this_biome.."_plains", this_biome.."_mountains"}

-- PLAINS
aom_biomes.register_biome({
    name = these_biomes[1],

    node_top = 'aom_soil:grass',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 30,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 20,

    heat_point = 100,
    humidity_point = 40,
}, {"forest", "ash", "overworld", "flowers", "grass"})
-- MOUNTAINS
aom_biomes.register_biome({
    name = these_biomes[2],

    node_top = 'aom_soil:grass',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    y_max = alt_max,
    y_min = sealevel + 31,
    -- y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 100,
    humidity_point = 40,
}, {"forest", "ash", "overworld"})

if minetest.get_modpath("aom_weather") then
    for i, biome in ipairs(these_biomes) do
        aom_weather.allow_biome_weathers(biome, {
            "light_rain",
            "heavy_rain",
            "snow",
            "heavy_snow",
        }, false)
    end
    -- minetest.log("adding weathers")
end

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path

aom_biomes.add_boulders({
    biomes = these_biomes,
    place_on = {"group:soil", "group:stone"},
    chance = 1,
    height_offset = 0,
    np = {
        offset = -0.015,
        scale = 0.02,
        spread = {x = 10, y = 10, z = 10},
        seed = 64758,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 1.7,
    },
})

-- //////////////
-- SIERA STRUCTURES
-- //////////////

local np_structure = {
    offset = -0.019,
    scale = 0.017,
    spread = {x = 40, y = 40, z = 40},
    seed = 6875,
    octaves = 4,
    persistence = 0.7,
    lacunarity = 2.1,
}


-- ruin
np_structure.offset = -0.0000
np_structure.scale = 0.0010
for i = 0, 0 do
    for k = 0, 1 do
        minetest.register_decoration({
            deco_type = "schematic",
            place_on = {"group:soil", "group:stone"},
            sidelen = 16,
            biomes = these_biomes,
            noise_params = np_structure,
            y_max = alt_max,
            y_min = sealevel,
            schematic = sch("siera_ruin_"..tostring(i)),
            flags = "place_center_x, place_center_z, force_placement",
            rotation = "random",
            place_offset_y = -17 + k * 2,
        })
    end
end
-- TOWERS
np_structure.offset = -0.000
np_structure.scale = 0.001
for i = 0, 1 do
    for k = 1, 3 do
        minetest.register_decoration({
            deco_type = "schematic",
            place_on = {"group:soil", "group:stone"},
            sidelen = 16,
            biomes = these_biomes,
            noise_params = np_structure,
            y_max = alt_max,
            y_min = sealevel,
            schematic = sch("siera_tower_ruin_"..tostring(i)),
            flags = "place_center_x, place_center_z, force_placement",
            rotation = "random",
            place_offset_y = -25 + k * 4,
        })
    end
end

np_structure.offset = -0.013
np_structure.scale = 0.010
for i = 1, 3 do
    -- np_structure.seed = np_structure.seed + 1
    for k = 1, 3 do
        minetest.register_decoration({
            deco_type = "schematic",
            place_on = {"group:soil", "group:stone"},
            sidelen = 16,
            biomes = these_biomes,
            noise_params = np_structure,
            y_max = alt_max,
            y_min = sealevel,
            schematic = sch("siera_tower_"..tostring(i)),
            flags = "place_center_x, place_center_z, force_placement",
            rotation = "random",
            place_offset_y = -25 + k * 4,
        })
    end
end

-- GIANT ash
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = {
        offset = -0.015,
        scale = 0.0385,
        spread = {x = 100, y = 100, z = 100},
        seed = 64758,
        octaves = 5,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = these_biomes,
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


-- ash 2
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    -- fill_ratio = 0.001,
    noise_params = {
        offset = -0.004,
        scale = 0.0075,
        spread = {x = 20, y = 20, z = 20},
        seed = 71,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 1.0,
    },
    biomes = these_biomes,
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- ash
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0006,
    biomes = these_biomes,
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

for i = 0, 2 do
    -- also do some OAK trees
    minetest.register_decoration({
        deco_type = "schematic",
        place_on = {"group:soil"},
        sidelen = 8,
        noise_params = {
            offset = -0.0025,
            scale = 0.008,
            spread = {x = 10, y = 10, z = 10},
            seed = 73355,
            octaves = 3,
            persistence = 0.2,
            lacunarity = 2.0,
        },
        biomes = these_biomes,
        y_max = alt_max,
        y_min = sealevel,
        schematic = sch("tree_oak_"..tostring(i)),
        flags = "place_center_x, place_center_z",
        rotation = "random",
        place_offset_y = -0
    })
end

for i = 0, 2 do
    -- also do some OAK trees
    minetest.register_decoration({
        deco_type = "schematic",
        place_on = {"group:soil"},
        sidelen = 8,
        noise_params = {
            offset = -0.0025,
            scale = 0.008,
            spread = {x = 10, y = 10, z = 10},
            seed = 73355,
            octaves = 3,
            persistence = 0.2,
            lacunarity = 2.0,
        },
        biomes = these_biomes,
        y_max = alt_max,
        y_min = sealevel,
        schematic = sch("tree_oak_huge_"..tostring(i)),
        flags = "place_center_x, place_center_z",
        rotation = "random",
        place_offset_y = -0
    })
end


minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = these_biomes,
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = these_biomes,
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0
})
-- bushes
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    -- fill_ratio = 0.006,
    biomes = these_biomes,
    noise_params = {
      offset = 0.05,
      scale = 0.2,
      spread = {x = 10, y = 10, z = 10},
      seed = 6,
      octaves = 8,
      persistence = 0.7,
      lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    -- fill_ratio = 0.006,
    biomes = these_biomes,
    noise_params = {
      offset = -0.1,
      scale = 0.2,
      spread = {x = 10, y = 10, z = 10},
      seed = 6,
      octaves = 8,
      persistence = 0.7,
      lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_bush_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0,
})


local size = 30
minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_stone:cobble",
    wherein		= {"aom_soil:grass", "aom_soil:dirt"},
    clust_scarcity	= 200,
    clust_size	= 12,
    noise_params = {
        offset = 0.3,
        scale = 0.5,
        spread = {x = size, y = size, z = size},
        seed = 438,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.1,
    },
    y_max = alt_max,
    y_min = sealevel,
    biomes = {these_biomes[2]},
})

size = 10
minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_stone:stone",
    wherein		= {"aom_stone:cobble"},
    clust_scarcity	= 100,
    clust_size	= 8,
    noise_params = {
        offset = 0.3,
        scale = 0.4,
        spread = {x = size, y = size, z = size},
        seed = 5275,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.1,
    },
    y_max = alt_max,
    y_min = sealevel,
    biomes = {these_biomes[2]},
})

local np = {
    offset = sealevel+70,
    scale = 200,
    spread = {x = 4, y = 4, z = 4},
    seed = 764,
    octaves = 2,
    persistence = 0.02,
    lacunarity = 2.0,
}
local npt = {
    offset = -00,
    scale = 190,
    spread = {x = 4, y = 4, z = 4},
    seed = 907,
    octaves = 2,
    persistence = 0.01,
    lacunarity = 2.0,
}

minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_stone:cobble_moss_1",
    wherein		= {"aom_stone:cobble"},
    clust_scarcity	= 200,
    clust_size	= 6,
    noise_params = np,
    y_max = alt_max,
    y_min = sealevel,
    biomes = these_biomes,
})
np.seed = 42983
minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_stone:cobble_moss_2",
    wherein		= {"aom_stone:cobble_moss_1"},
    clust_scarcity	= 200,
    clust_size	= 4,
    noise_params = np,
    y_max = alt_max,
    y_min = sealevel,
    biomes = these_biomes,
})
