
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'ash_forest'

aom_biomes.register_biome({
    name = this_biome,

    node_top = 'aom_soil:dirt_with_grass',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 120,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 86,
    humidity_point = 41,
}, {"forest", "ash", "overworld", "flowers", "grass"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path

aom_biomes.add_boulders({
    biomes = {this_biome},
    place_on = {"group:soil", "group:stone"},
    chance = 1,
    height_offset = 0,
    np = {
        offset = -0.01,
        scale = 0.02,
        spread = {x = 10, y = 10, z = 10},
        seed = 64758,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 1.7,
    },
})

-- GIANT ash
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = -0.001,
        scale = 0.0185,
        spread = {x = 100, y = 100, z = 100},
        seed = 64758,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


-- ash 2
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    -- fill_ratio = 0.001,
    noise_params = {
        offset = -0.004,
        scale = 0.0075,
        spread = {x = 10, y = 10, z = 10},
        seed = 71,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 1.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- ash
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0016,
    -- noise_params = {
    --   offset = -0.004,
    --   scale = 0.0175,
    --   spread = {x = 10, y = 10, z = 10},
    --   seed = 6,
    --   octaves = 8,
    --   persistence = 0.7,
    --   lacunarity = 2.0,
    -- },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


-- also do some OAK trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0
})
-- bushes
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 8,
    -- fill_ratio = 0.006,
    biomes = {this_biome},
    noise_params = {
      offset = -0.1,
      scale = 0.2,
      spread = {x = 10, y = 10, z = 10},
      seed = 6,
      octaves = 8,
      persistence = 0.7,
      lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 8,
    -- fill_ratio = 0.006,
    biomes = {this_biome},
    noise_params = {
      offset = -0.1,
      scale = 0.2,
      spread = {x = 10, y = 10, z = 10},
      seed = 6,
      octaves = 8,
      persistence = 0.7,
      lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_bush_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0,
})