local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

aom_gates.register_gate("aom_machines:iron_gate", {
    description = S("Iron Gate"),
    _tt_color = 2,
    _tt_long_desc = S("Can be toggled open or closed using a gate controller."),
    groups = { cracky = 2, oddly_breakable_by_hand = 3, solid = 1,
        mechanisms = 1, aom_gates = 1, },
    tiles = {"aom_gates_iron.png"},
    sounds = aom_sounds.default_metal(),
    _gate_width = 2/16,
    _gate_open_pointable = false,
})

aom_gates.register_gate("aom_machines:drawbridge", {
    description = S("Iron drawbridge"),
    _tt_color = 2,
    _tt_long_desc = S("Can be toggled open or closed using a gate controller."),
    groups = { cracky = 2, oddly_breakable_by_hand = 3, solid = 1,
        mechanisms = 1, aom_gates = 1, },
    tiles = {"aom_gates_drawbridge_top.png", "aom_gates_drawbridge_top.png", "aom_gates_drawbridge.png"},
    paramtype2 = "facedir",
    sounds = aom_sounds.default_wood(),
    on_place = function(itemstack, placer, pointed_thing)
        return minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
    end,
    _gate_open_pointable = false,
})


-- CRAFTING
if aom_machines.has_aom_tcraft then
    aom_tcraft.register_craft({
        output = "aom_machines:iron_gate 8",
        items = {
            ["aom_items:iron_bar"] = 1,
        },
    })
    aom_tcraft.register_craft({
        output = "aom_machines:drawbridge 8",
        items = {
            ["aom_items:iron_bar"] = 1,
            ["aom_wood:oak_log"] = 4,
        },
    })
    aom_tcraft.register_craft({
        output = "aom_gates:drawbridge 8",
        items = {
            ["aom_items:iron_bar"] = 1,
            ["aom_wood:spruce_log"] = 4,
        },
    })
    aom_tcraft.register_craft({
        output = "aom_gates:drawbridge 8",
        items = {
            ["aom_items:iron_bar"] = 1,
            ["aom_wood:ash_log"] = 4,
        },
    })
end
