local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_tool("aom_wings:glowfibre", {
    description = S("Glowfibre Wings"),
    _tt_color = "#f0f",
    _tt_long_desc = "[wip] These are not animated, but work.\n"..
    "Jump while falling to activate, or use [sprint] + [up] + [place] to slingshot.",
    inventory_image = "aom_wings_glowfibre.png",

    _on_equipment_step = function(itemstack, player, dtime, list_name, list_index)
        -- if list_name ~= "armor" and list_index ~= 2 then return end
        local ret = aom_wings.on_equipment_step(itemstack, player, dtime, list_name, list_index)

        local pi = aom_wings.get_player_info(player)
        if pi and pi.flying then
            if (pi._wingflaptime or 1) > 0 then pi._wingflaptime = (pi._wingflaptime or 1) - dtime
            end
            local ctrl = player:get_player_control()
            local flapped = (ctrl and ctrl.jump and (pi._wingflaptime <= 0))
            if flapped then
                pi._wingflaptime = pi._wingflaptime + 0.5
                pi.last_speed = math.min(5, pi.last_speed)
                local dir = player:get_look_dir() * 2
                player:add_velocity(vector.new(dir.x, 10, dir.z))
                -- pi.last_speed = pi.last_speed + 5
                minetest.sound_play("aom_wings_open", {
                    gain = 0.2,
                    object = player,
                    pitch = 0.7 + math.random() * 0.4,
                })
            end
            -- fall
            if (pi.last_speed < 7) then
                local ldir = player:get_look_dir()
                if ldir.y < 0.3 then
                    pi.last_speed = 7
                else
                    pi.last_speed = pi.last_speed / 2
                end
            end
            if ctrl and ctrl.sneak then
                aom_wings.to_walking(itemstack, player, nil)
            end
        end
        return ret
    end,
    _on_equipped = function(itemstack, player, info)
        if info and not info.is_from_joining then
            minetest.sound_play("aom_lantern_take_out", {
                gain = 0.14,
                object = player,
            })
        end
        return aom_wings.on_equipped(itemstack, player, info)
    end,
    _on_unequipped = function(itemstack, player, info)
        return aom_wings.on_unequipped(itemstack, player)
    end,

    _cooldown = 10,

    _wings_params = {
        max_speed = 20,
        gravity = 0.6,
        max_acceleration = 300,
        deceleration = 0.01,
        auto_pitch_up = 0.6,
        auto_pitch_up_scale_factor = -0.1 / 20, -- per speed

        fall_bonus = 0.6, -- how much accel per pos.y fallen
        climb_penalty = 0.5, -- how much to slow down per pos.y climbed
        -- lift_factor = 0.5,
        -- lift_max = 0.1,
        -- lift_min = 0.0,
        start_mult_y = 0, -- for each vel.y
        start_mult_vel = 1, -- for each length(vel)
        start_vel_cancel = 0.9, -- cancel out real vel
        start_vel_cancel_max = 10, -- max to cancel Y vel
        start_vel_add = 0.3, -- add more real vel (1 means double cur vel)
        low_speed_threshold = 14,
        low_speed_bonus = 0.1,

        collision_factor = 0.4,
        collision_threshold = 0.1, -- above this, vel will be mult by above

        pitch_clamp = 0.9,
        -- pitch_acc = 0.0, -- how much accel per dir.y down
        pitch_acc_bonus = -0.01, -- pretend looking down this much
        pitch_up_penalty = 0.03,
        -- lift_resistance = 0.0, -- resists lift, but doesn't affect inertia
        -- lift_resistance_threshold = 0.3, -- resists lift only when vel.y > -this
        yaw_deceleration = 4, -- per half rotation (pi)
        yaw_deceleration_threshold = 7, -- radians per sec, under this, yaw decel is x / 10

        slingshot_allow = true, -- allows sprint + rclick to slingshot the player
        slingshot_speed = 40, -- overrides speed after slingshot
        slingshot_velocity = 30, -- how much actuall vel to add when starting slingshot; how far up you fling
        slingshot_delay = 2, -- max amount of time before cancelling slingshot
        slingshot_vel_threshold = 200, -- vel.y < this --> start flying
        slingshot_direction = vector.new(0.99, 0.6, 0.99),
        walk_speed = 0.01,
        take_vel_factor = vector.new(2, 1.5, 2),
        speed_factor = vector.new(2, 1.5, 2),

        hud = true,
        wind = true,
        sound_wind_factor = 0.5,
        fov = true,
        max_fov = 0.2,
    },
    _wings_on_fly = function(itemstack, player)
        minetest.sound_play("aom_wings_open", {
            gain = 0.9,
            object = player,
            pitch = 0.9 + math.random() * 0.1,
        })
        local pi = aom_wings.get_player_info(player)
        if pi then
            pi._wingflaptime = 0.3
        end
    end,
    _wings_on_land = function(itemstack, player)
    end,

    groups = { wings = 1, armor_chest = 1, tool = 1, equipment_armor = 1 },
})

if minetest.get_modpath("aom_tcraft") then
    aom_tcraft.register_craft({
        output = "aom_wings:glowfibre",
        items = {
            ["unobtainable"] = 1,
        }
    })
end


