
aom_playerapi.controls = {}

function aom_playerapi.controls.get_player_control(player)
    return aom_playerapi.check_player(player).ctrl
end

function aom_playerapi.update_controls(player, pi)
    local ctrl = player:get_player_control()
    if not pi.ctrl then
        pi.ctrl = {}
        pi.ctrl.last = ctrl
        pi.ctrl.just_pressed = {}
        pi.ctrl.just_released = {}
    end
    pi.ctrl.pressed = ctrl
    for k, is_pressed in pairs(pi.ctrl.pressed) do
        pi.ctrl.just_pressed[k] = (is_pressed and not pi.ctrl.last[k])
        pi.ctrl.just_released[k] = ((not is_pressed) and pi.ctrl.last[k])
    end
    pi.ctrl.last = ctrl
end

aom_playerapi.register_on_player_step(function(player, dtime, pi)
    aom_playerapi.update_controls(player, pi)
end)
