
aom_inventory.register_formspec_process("crafting", "aom_inventory:main", function(flags)
    local offset, size = flags.offset, flags.size
    if offset==nil then offset = {x=7.5, y=11.5} end
    if size==nil then size = {x=aom_inventory.player.width, y=aom_inventory.player.height} end
    if not minetest.get_modpath("aom_settings") then return end

    local x = offset.x + size.x + 0.25
    local y = offset.y - 1 + 0.25
    return table.concat({
        "style_type[button;bgimg=aom_inv_btn.png\\^\\[multiply:#616161;bgimg_middle=8;",
        "bgimg_hovered=aom_inv_btn.png\\^\\[multiply:#616161;bgimg_pressed=aom_inv_btn_press.png\\^\\[multiply:#616161;",
        "bgcolor_hovered=#eee;bgcolor_pressed=#fff]","style_type[button;border=false]",
        "button[", x, ",", y, ";2,1;","aom_igm_open",";player menu]"
})
end)

aom_inventory.register_on_formspec_action("", "aom_igm_open", function(player, formname, fields)
    minetest.sound_play("aom_igm_click", {
        gain = 1 * aom_igm.get_setting(player, "sound_menu_volume", 1),
        to_player = player:get_player_name(),
    })
    aom_igm.show_page(player, "main")
    return true
end)
