local elemname = "bform_label"

---@class bform_label : bform_prototype
---@field text string
local class = setmetatable({}, {__index = aom_bform.prototype})
class.type = elemname

-- label[<X>,<Y>;<label>]

---@return table
function class:render(fs, data, ...)
    table.insert(fs, table.concat({
        "label[", self.pos[1], ",", self.pos[2], ";", self.text, "]"
    }))
    return fs
end

---@return table
function class:render_after(fs, data, ...)
    return fs
end

---@return bform_label
function class.new(size, text, offset, id)
    local ret = {
        id = id,
        size = size or {0, 0},
        text = core.formspec_escape(text or ""),
        offset = offset or {0, 0},
        --
        dir = {0,1},
        pos = {0, 0},
        children = {},
    }
    return setmetatable(ret, {__index = class})
end

aom_bform.element.label = class
