
local function tmpfix(pos, formname, fields, player)
    local meta = minetest.get_meta(pos)
    local node_formname = meta:get_string("formname")
    if node_formname ~= "" then
        formname = node_formname
    else
        formname = "nodemeta:"..pos.x..","..pos.y..","..pos.z
    end
    if not minetest.is_player(player) then return end
    for _, func in ipairs(minetest.registered_on_player_receive_fields) do
        if func(player, formname, fields) == true then return end
    end
end

minetest.register_on_mods_loaded(function()
    for nodename, def in pairs(minetest.registered_nodes) do
        if def._has_formspec then
            minetest.override_item(nodename, {
                on_receive_fields = tmpfix
            })
        end
    end
end)
