local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node('aom_underworld:lava_brick', {
    description = S("Lava Bricks"),
    groups = { full_solid = 1, item_lava_brick = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_lava_brick.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
if true then
    local s = "aom_underworld:lava_rock"
    minetest.register_craft({
        output = "aom_underworld:lava_brick 4",
        recipe = {
        {s, s},
        {s, s},
        },
    })
end
aom_util.register_all_shapes("aom_underworld:lava_brick")


minetest.register_node('aom_underworld:lava_brick_fine', {
    description = S("Fine Lava Bricks"),
    groups = { full_solid = 1, item_lava_brick_fine = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_lava_brick_fine.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
if true then
    local s = "aom_underworld:lava_rock"
    local g = "aom_underworld:lava_brick"
    minetest.register_craft({
        output = "aom_underworld:lava_brick_fine 6",
        recipe = {
        {s, s},
        {g, g},
        {g, g},
        },
    })
end
aom_util.register_all_shapes("aom_underworld:lava_brick_fine")


minetest.register_node('aom_underworld:lava_brick_ornate', {
    description = S("Ornate Lava Bricks"),
    groups = { full_solid = 1, item_lava_brick_ornate = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_lava_brick_ornate.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
if true then
    local s = "aom_underworld:lava_brick"
    minetest.register_craft({
        output = "aom_underworld:lava_brick_ornate 4",
        recipe = {
        {s, s},
        {s, s},
        },
    })
end
aom_util.register_all_shapes("aom_underworld:lava_brick_ornate")


minetest.register_node('aom_underworld:lava_brick_lamp', {
    description = S("Lava Brick Lamp"),
    groups = { full_solid = 1, item_lava_brick_lamp = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = aom_util.node_light_unfck("aom_underworld_lava_brick_lamp.png"),
    sounds = aom_sounds.default_stone(),
    light_source = 14,
    paramtype = "light",
})
if true then
    local s = "aom_underworld:lava_brick"
    local l = "aom_underworld:glow_rock"
    minetest.register_craft({
        output = "aom_underworld:lava_brick_lamp 8",
        recipe = {
        {l},
        {s},
        },
    })
end
aom_util.register_all_shapes("aom_underworld:lava_brick_lamp")


minetest.register_node('aom_underworld:lava_brick_pillar', {
    description = S("Lava Brick Pillar"),
    groups = { full_solid = 1, item_lava_brick_pillar = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_lava_brick_pillar_top.png", "aom_underworld_lava_brick_pillar_top.png", "aom_underworld_lava_brick_pillar.png", },
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    on_place = aom_util.rotate_and_place,
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
if true then
    local s = "aom_underworld:lava_brick"
    minetest.register_craft({
        output = "aom_underworld:lava_brick_pillar 3",
        recipe = {
        {s},
        {s},
        {s},
        },
    })
end
aom_util.register_all_shapes("aom_underworld:lava_brick_pillar")


minetest.register_node('aom_underworld:lava_brick_coral', {
    description = S("Coral Covered Lava Bricks"),
    groups = { full_solid = 1, item_lava_brick_coral = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_lava_brick_coral.png"},
    sounds = aom_sounds.default_stone(),
    light_source = aom_underworld.lava_rock_light,
    -- paramtype = "light",
})
if true then
    local s = "aom_underworld:lava_brick"
    local g = "aom_underworld:glow_rock"
    minetest.register_craft({
        output = "aom_underworld:lava_brick_coral 4",
        recipe = {
        {s, g},
        {g, s},
        },
    })
end
aom_util.register_all_shapes("aom_underworld:lava_brick_coral")
