
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'taiga_tall'

aom_biomes.register_biome({
    name = this_biome,

    node_top = 'aom_soil:forest_dirt',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    -- node_water_top = "aom_soil:snow",
    -- depth_water_top = 1,

    y_max = sealevel + 30,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 30,
    humidity_point = 70,
}, {"spruce", "overworld"})


-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path


local size = 20
-- FOREST GRASS
minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_soil:forest_grass",
    wherein		= {"aom_soil:forest_dirt"},
    clust_scarcity	= 200,
    clust_num_ores	= 6,
    clust_size	= 5,
    noise_params = {
        offset = -0.05,
        scale = 1,
        spread = {x = size, y = size, z = size},
        seed = 5433,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    biomes = {this_biome},
})

size = 30
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_soil:forest_grass_1",
    wherein		= {"group:topsoil"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 5643,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 40,
        scale = 90,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_soil:forest_grass_2",
    wherein		= {"aom_soil:forest_grass_1"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 5643,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 0,
        scale = 90,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 5,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})




minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.00002,
    biomes = {this_biome},
    y_min = -10,
    y_max = 200,
    schematic = sch("boulder_0"),
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
    place_offset_y = -2
})

minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.00002,
    biomes = {this_biome},
    y_min = -10,
    y_max = 200,
    schematic = sch("boulder_1"),
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
    place_offset_y = 0
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.00002,
    biomes = {this_biome},
    y_min = -10,
    y_max = 200,
    schematic = sch("boulder_2"),
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
    place_offset_y = -2
})

-- lots of bunched up trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.01,
        scale = 0.0035,
        spread = {x = 50, y = 50, z = 50},
        seed = 354,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_spruce_giant_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- lots of bunched up trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.01,
        scale = 0.0035,
        spread = {x = 50, y = 50, z = 50},
        seed = 354,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_spruce_tall_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.01,
        scale = 0.0035,
        spread = {x = 50, y = 50, z = 50},
        seed = 234,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_spruce_tall_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.01,
        scale = 0.0035,
        spread = {x = 50, y = 50, z = 50},
        seed = 654,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_spruce_tall_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.01,
        scale = 0.0025,
        spread = {x = 50, y = 50, z = 50},
        seed = 6564,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_spruce_tall_3"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.0005,
        scale = 0.0019,
        spread = {x = 50, y = 50, z = 50},
        seed = 765,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_spruce_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_1"},
    sidelen = 80,
    noise_params = {
        offset = 0.01,
        scale = 0.0025,
        spread = {x = 50, y = 50, z = 50},
        seed = 765,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_spruce_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_1"},
    sidelen = 80,
    noise_params = {
        offset = 0.01,
        scale = 0.0025,
        spread = {x = 50, y = 50, z = 50},
        seed = 5643,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_spruce_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1
})




size = 30
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_soil:dirt_with_grass",
    wherein		= {"aom_soil:forest_dirt"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 765,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = -50,
        scale = 190,
        spread = {x = 20, y = 20, z = 20},
        seed = 987,
        octaves = 5,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})

local function do_fern_stuff(num, seed)
    minetest.register_decoration({
        deco_type = "simple",
        place_on = {"aom_soil:grass"},
        sidelen = 4,
        noise_params = {
            offset = -0.2,
            scale = 0.5,
            spread = {x = 20, y = 20, z = 20},
            seed = seed,
            octaves = 1,
            persist = 1.2
        },
        biomes = {this_biome},
        y_max = alt_max,
        y_min = sealevel,
        decoration = "aom_flora:fern_"..num,
    })
end


do_fern_stuff(0, 6546)
do_fern_stuff(1, 6546)
-- do_fern_stuff(1, 90)
-- do_fern_stuff(2, 345)

for i = 2, 0, -1 do
    -- bushes in large sparse clumps
    minetest.register_decoration({
        deco_type = "schematic",
        place_on = {"aom_soil:forest_grass_1"},
        sidelen = 1,
        noise_params = {
            offset = -0.1,
            scale = 0.3,
            spread = {x = 4, y = 4, z = 4},
            seed = 654,
            octaves = 2,
            persist = 0.2,
            lucanarity = 2.78,
        },
        biomes = {this_biome},
        y_max = alt_max,
        y_min = sealevel,
        schematic = sch("tree_spruce_bush_" .. i),
        flags = "place_center_x, place_center_z",
        place_offset_y = 1,
        rotation = "random",
    })
end

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"aom_soil:forest_grass_1"},
    sidelen = 1,
    noise_params = {
        offset = -0.1,
        scale = 0.4,
        spread = {x = 4, y = 4, z = 4},
        seed = 654,
        octaves = 2,
        persist = 0.2,
        lucanarity = 2.78,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    decoration = "aom_flora:shrub_0",
})

