local S = minetest.get_translator(minetest.get_current_modname())

aom_warning = {}

local formspec = table.concat({
    "formspec_version[6]",
    "size[24.0,12.0]",
    "no_prepend[]",
    "bgcolor[#00000000]",
    "image[6,0;12,12;bform_bg_opaque.png^[multiply:#19181f^(bform_bg_outline.png^[multiply:#000);28]",
    "style_type[image_button;bgimg=blank.png;bgimg_hovered=blank.png]",
    "style_type[image_button;border=false]",

    "image[10.1,0.6;4,2;aom_title_2x1.png^[colorize:#00000040:250]",
    "image[10,0.4;4,2;aom_title_2x1.png]",

    "container[7,3]",
        "textarea[0,0.5;10,1.5;; ;",
            core.formspec_escape(S("This game is in alpha. Breaking changes will happen, and will usually (but not guaranteed) be listed in the official changelog:")),
        "]",
        "box[0.5,1.7;8.5,0.6;#111111e0]",
        -- "field[0.7,1.7;9.5,0.6;url;;https://codeberg.org/Age_of_Mending/Age_of_Mending/releases]",
        "style_type[textarea;border=false;textcolor=#4d8]",
        "textarea[0.7,1.85;9.5,0.6;; ;",
            core.formspec_escape("https://codeberg.org/Age_of_Mending/Age_of_Mending/releases"),
        "]",
        "field_close_on_enter[url;false]",

        "style_type[textarea;border=false;textcolor=#fff]",
        "textarea[0,2.5;9.5,1;; ;",
            core.formspec_escape(S("If in doubt, make backups of your worlds before updating!")),
        "]",

        "style_type[textarea;border=false;textcolor=#f3a667]",
        "textarea[0,3.3;9.5,1.0;; ;",
            core.formspec_escape(S("The direction of the game might change substantially, since it's a game design challenge and experiment as much as a form of entertainment.")),
        "]",

        "label[0,4.4;",
            core.formspec_escape(core.colorize("#ddd5d0", "_________")),
        "]",

        "style_type[textarea;border=false;textcolor=#fea]",
        "textarea[0,4.6;9.5,1.0;; ;",
            core.formspec_escape(core.colorize("#fea", S("Sumi, creator of Age of Mending"))),
        "]",
        "image[-0.3,4.9;1.5,1.5;aom_sumi.png]",

        "style_type[textarea;border=false;textcolor=#888]",
        "textarea[-0.5,8.3;9.5,1;; ;",
            -- TL: @1 is "/alphawarning"
            core.formspec_escape(S("This message can be shown again with @1", "/alphawarning")),
        "]",

        "set_focus[start;true]",
        "style_type[label;font_size=*2]",
        "label[0,0.0;"..core.colorize("#fe8", S("About Alpha")).."]",
        "image_button[3,7;4,1;gm_windmills_button_start.png;","start","; Ok]",
    "container_end[]",
})

if core.get_modpath("aom_settings") then
    aom_settings.register_setting("menu_show_alpha_warning", true, S("Show alpha warning to new players"), "server")
end

local function show_warning(name)
    core.show_formspec(name, "aom_warning", formspec)
end

-- if this increments higher than the last version a player loaded, they get shown again
local last_show_version = 0

core.register_on_joinplayer(function(player, last_login)
    local disabled = core.get_modpath("aom_settings") and not aom_settings.get_setting(nil, "menu_show_alpha_warning", true)
    if disabled then return end
    local is_show = (not last_login)
    local meta = player:get_meta()
    local last_player_version = tonumber(meta:get_string("aom_warning:version")) or 0
    if last_player_version < last_show_version then
        meta:set_string("aom_warning:version", last_show_version)
        is_show = true
    end
    if (is_show) and (not disabled) then
        local name = player:get_player_name()
        show_warning(name)
        -- TL: @1 is a URL
        core.chat_send_player(name, S("Welcome to Age of Mending! See licenses at @1", "https://codeberg.org/Age_of_Mending/Age_of_Mending"))
    end
end)

aom_util.formspec_actions.register_on_form_fields("aom_warning", function(player, formname, fields)
    if fields.start then
        core.close_formspec(player:get_player_name(), formname)
    end
end)

core.register_chatcommand("alphawarning", {
    params = "",
    description = S("Opens the alpha warning you get when you join the first time."),
    privs = {},
    func = function(name, param)
        show_warning(name)
        return true
    end
})
