local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node('aom_underworld:arlior_brick', {
    description = S("Arlior Bricks"),
    _tt_color = 2,
    groups = { full_solid = 1, material_arlior = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_arlior_brick.png"},
    sounds = aom_sounds.default_stone(),
})
if true then
    local s = "aom_underworld:arlior"
    minetest.register_craft({
        output = "aom_underworld:arlior_brick 4",
        recipe = {
        {s, s},
        {s, s},
        },
    })
end
aom_util.register_all_shapes("aom_underworld:arlior_brick")


minetest.register_node('aom_underworld:arlior_brick_fine', {
    description = S("Fine Arlior Bricks"),
    _tt_color = 2,
    groups = { full_solid = 1, material_arlior = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_arlior_brick_fine.png"},
    sounds = aom_sounds.default_stone(),
})
if true then
    local s = "aom_underworld:arlior"
    local g = "aom_underworld:arlior_brick"
    minetest.register_craft({
        output = "aom_underworld:arlior_brick_fine 6",
        recipe = {
        {s, s},
        {g, g},
        {g, g},
        },
    })
end
aom_util.register_all_shapes("aom_underworld:arlior_brick_fine")


minetest.register_node('aom_underworld:arlior_brick_ornate', {
    description = S("Ornate Arlior Bricks"),
    _tt_color = 2,
    groups = { full_solid = 1, material_arlior = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_arlior_brick_ornate_top.png", "aom_underworld_arlior_brick_ornate_top.png", "aom_underworld_arlior_brick_ornate.png", },
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    on_place = aom_util.rotate_and_place,
})
if true then
    local s = "aom_underworld:arlior_brick"
    minetest.register_craft({
        output = "aom_underworld:arlior_brick_ornate 3",
        recipe = {
        {s},
        {s},
        {s},
        },
    })
end
aom_util.register_all_shapes("aom_underworld:arlior_brick_ornate")


minetest.register_node('aom_underworld:arlior_brick_lamp', {
    description = S("Arlior Lamp"),
    _tt_color = 2,
    groups = { full_solid = 1, material_arlior_lamp = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_underworld_arlior_brick_lamp.png"},
    sounds = aom_sounds.default_stone(),
    light_source = 10,
    paramtype = "light",
})
if true then
    local s = "aom_underworld:arlior_brick"
    local m = "aom_underworld:arlior_mushroom_blue"
    minetest.register_craft({
        output = "aom_underworld:arlior_brick_lamp 8",
        recipe = {
        {s, s, s},
        {s, m, s},
        {s, s, s},
        },
    })
end

aom_util.register_all_shapes("aom_underworld:arlior_brick_lamp")