local S = core.get_translator(core.get_current_modname())


minetest.register_node('aom_stone:stone_brick', {
    description = S("Stone Brick"),
    groups = { full_solid = 1, stone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    -- tiles = {"aom_stone_brick.png"},
    tiles = {
        {
            name="aom_stone_brick.png", align_style="world", scale=4
        }
    },
    sounds = aom_sounds.default_stone(),
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "aom_stone:cobble"
    minetest.register_craft({
        output = "aom_stone:stone_brick 4",
        recipe = {
        {g, g},
        {g, g},
        },
    })
end
aom_util.register_all_shapes("aom_stone:stone_brick")


minetest.register_node('aom_stone:stone_brick_fine', {
    description = S("Fine Stone Brick"),
    groups = { full_solid = 1, stone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_stone_brick_fine.png"},
    sounds = aom_sounds.default_stone(),
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local s = "aom_stone:cobble"
    local g = "aom_stone:stone_brick"
    minetest.register_craft({
        output = "aom_stone:stone_brick_fine 6",
        recipe = {
        {s, s},
        {g, g},
        {g, g},
        },
    })
end
aom_util.register_all_shapes("aom_stone:stone_brick_fine")


minetest.register_node('aom_stone:stone_brick_ruin', {
    description = S("Ruined Stone Brick"),
    groups = { full_solid = 1, stone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        {
            name="aom_stone_brick_ruin.png", align_style="world", scale=4
        }
    },
    sounds = aom_sounds.default_stone(),
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "aom_stone:stone_brick"
    minetest.register_craft({
        output = "aom_stone:stone_brick_ruin 4",
        recipe = {
        {g, g},
        {g, g},
        },
    })
end
aom_util.register_all_shapes("aom_stone:stone_brick_ruin")


minetest.register_node('aom_stone:stone_brick_pillar', {
    description = S("Stone Brick Pillar"),
    groups = { full_solid = 1, stone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_stone_brick_pillar_top.png", "aom_stone_brick_pillar_top.png", "aom_stone_brick_pillar.png"},
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    on_place = aom_util.rotate_and_place,
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "aom_stone:stone_brick"
    minetest.register_craft({
        output = "aom_stone:stone_brick_pillar 3",
        recipe = {
        {g},
        {g},
        {g},
        },
    })
end
aom_util.register_all_shapes("aom_stone:stone_brick_pillar")


minetest.register_node('aom_stone:stone_brick_ornate', {
    description = S("Stone Brick Ornate"),
    groups = { full_solid = 1, stone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_stone_brick_ornate.png"},
    sounds = aom_sounds.default_stone(),
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "aom_stone:stone_brick"
    minetest.register_craft({
        output = "aom_stone:stone_brick_ornate 4",
        recipe = {
        {g, g},
        {g, g},
        },
    })
end
aom_util.register_all_shapes("aom_stone:stone_brick_ornate")


minetest.register_node('aom_stone:stone_brick_lamp', {
    description = S("Stone Brick Lamp"),
    groups = { full_solid = 1, stone = 1, material_stone_lamp = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = aom_util.node_light_unfck("aom_stone_stone_brick_lamp.png"),
    sounds = aom_sounds.default_stone(),
    light_source = 14,
    paramtype = "light",
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "aom_stone:stone_brick_ornate"
    local l = "aom_lights:torch"
    minetest.register_craft({
        output = "aom_stone:stone_brick_lamp 1",
        recipe = {
        {l},
        {g},
        },
    })
end
aom_util.register_all_shapes("aom_stone:stone_brick_lamp")


local function place_long_brick(itemstack, placer, pointed_thing)
    local name = itemstack:get_name()
    local def = minetest.registered_nodes[name]
    if minetest.get_node(pointed_thing.under).name == name then
        itemstack:set_name(def._alternate)
        itemstack = minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true}, nil)
        itemstack:set_name(name)
    else
        itemstack = minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true}, nil)
    end
    return itemstack
end

minetest.register_node('aom_stone:stone_brick_left', {
    description = S("Double Stone Brick (left)"),
    _tt_long_desc = S("The Left side of a long brick."),
    groups = { full_solid = 1, stone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        -- top
        "aom_stone_brick_long_end_left.png",
        -- bottom
        "aom_stone_brick_long_end_left.png",
        -- right / east
        "aom_stone_brick_long_top.png",
        -- left / west
        "aom_stone_brick_long_top.png",
        -- behind / north (facedir)
        "aom_stone_brick_long_end_right.png",
        -- front / south (pointing at player)
        "aom_stone_brick_long_end_left.png",
    },
    inventory_image = "aom_stone_brick_long_inv.png^aom_stone_brick_long_inv_L.png",
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    _alternate = "aom_stone:stone_brick_right",
    on_place = place_long_brick,
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
if true then
    local g = "aom_stone:stone_brick"
    minetest.register_craft({
        output = "aom_stone:stone_brick_left 2",
        recipe = {
        {g, g},
        },
    })
end
minetest.register_node('aom_stone:stone_brick_right', {
    description = S("Double Stone Brick (right)"),
    _tt_long_desc = S("The right side of a long brick."),
    groups = { full_solid = 1, stone = 1, material_stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        -- top
        "aom_stone_brick_long_end_right.png",
        -- bottom
        "aom_stone_brick_long_end_right.png",
        -- right / east
        "aom_stone_brick_long_top.png",
        -- left / west
        "aom_stone_brick_long_top.png",
        -- behind / north (facedir)
        "aom_stone_brick_long_end_left.png",
        -- front / south (pointing at player)
        "aom_stone_brick_long_end_right.png",
    },
    inventory_image = "aom_stone_brick_long_inv.png^aom_stone_brick_long_inv_R.png",
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    _alternate = "aom_stone:stone_brick_left",
    drop = "aom_stone:stone_brick_left",
    on_place = place_long_brick,
    _scrap = {
        ["aom_scrap:stone"] = 8,
    },
})
minetest.register_craft({
    output = "aom_stone:stone_brick_right",
    recipe = {
    {"aom_stone:stone_brick_left"},
    },
})
minetest.register_craft({
    output = "aom_stone:stone_brick_left",
    recipe = {
    {"aom_stone:stone_brick_right"},
    },
})
