local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node("aom_underworld:arlior", {
    description = S("Arlior"),
    groups = { full_solid = 1, nature = 1, material_arlior = 1, underworld = 1, arlior = 1,
    oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2, },
    tiles = {"aom_underworld_arlior.png"},
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_underworld:arlior")


minetest.register_node("aom_underworld:arlioran", {
    description = S("Arlioran"),
    groups = { full_solid = 1, nature = 1, material_arlioran = 1, underworld = 1, arlior = 1,
    oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2, },
    tiles = {
        "aom_underworld_arlioran_top.png",
        "aom_underworld_arlior.png",
        "aom_underworld_arlioran_side.png",
    },
    drop = {
        max_items = 2,
        items = {
            {
                -- rarity = 1,
                items = {"aom_underworld:arlior"},
            },
        },
    },
    sounds = aom_sounds.default_soil(),
    _on_node_update = function(pos, cause, user, count, payload)
        if cause ~= "place" then return end
        local abovenode = minetest.get_node(vector.offset(pos, 0, 1, 0))
        if (abovenode.name ~= "air") and minetest.get_item_group(abovenode.name, 'full_solid') > 0 then
            minetest.set_node(pos, {name="aom_underworld:arlior"})
        end
    end
})

if true then
    local g = "aom_underworld:arlior_fola"
    local a = "aom_underworld:arlior"
    minetest.register_craft({
        output = "aom_underworld:arlioran",
        recipe = {
            {g},
            {a},
        },
    })
end
aom_util.register_slab("aom_underworld:arlioran", {drop="aom_underworld:arlior_slab", offset_textures=true})
aom_util.register_stair("aom_underworld:arlioran", {drop="aom_underworld:arlior_stair", offset_textures=true})


