local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local function teleport_forward(itemstack, player, pointed_thing, mult)
    local dist = 20
    local ctrl = player:get_player_control()
    if ctrl and ctrl.aux1 then dist = 200 end
    if not mult then mult = 1 end
    dist = dist * mult
    local dir = player:get_look_dir()
    player:set_pos(vector.add(player:get_pos(), vector.multiply(dir, dist)))
end

minetest.register_tool("aom_admin_tools:teleport_to", {
    description = S("Teleport Rod"),
    _tt_color = "#f0f",
    _tt_long_desc = S("Teleports you forward and grants greater speed when holding [aux1]."),
    _tt_how_to_use = S("[dig] teleport 20m forward") .. "\n" ..
        S("[place] teleport 60m forward") .. "\n" ..
        S("[aux1] multiply distance by 10x"),
    inventory_image = "aom_admin_tools_teleport_to.png",
    wield_image = "aom_admin_tools_teleport_to.png",
    tool_capabilities = {
        damage_groups = { fleshy = 999, cracky = 999 },
    },
    groups = { admin_tools = 1, not_in_creative_inventory = 1 },
    on_use = teleport_forward,
    on_secondary_use = function(itemstack, player, pointed_thing) teleport_forward(itemstack, player, pointed_thing, 3) end,
    on_place = function(itemstack, player, pointed_thing) teleport_forward(itemstack, player, pointed_thing, 3) end,

    _on_step = function(itemstack, player, dtime)
        if not minetest.get_modpath("playerphysics") then return end
        local pi = player:get_player_control()
        if pi and pi.aux1 and playerphysics then
            playerphysics.add_physics_factor(player, "speed", "aom_admin_tools:teleport_to", 5)
        else
            playerphysics.remove_physics_factor(player, "speed", "aom_admin_tools:teleport_to")
        end
    end,
    _on_deselect = function(itemstack, player)
        playerphysics.remove_physics_factor(player, "speed", "aom_admin_tools:teleport_to")
    end,
})
