local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_craftitem("aom_food:baked_potato", {
    description = S("Baked potato"),
    inventory_image = "aom_baked_potato.png",
    groups = { item_baked_potato = 1, craftitem = 1, food = 1, },
})
aom_util.register_wield_use_delay("aom_food:baked_potato", {
    windup = 2,
    sound = {
        name = "aom_food_munch",
        gain = 0.2,
        max_hear_distance = 10,
        pitch = 0.85
    },
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["regeneration_1"] = 2,
        ["regeneration_3"] = 3*2+1,
        ["regeneration_8"] = 8*4+1,
    })
})
aom_cooking.register_cooking({
    raw = "aom_flora:potato_seeds",
    cooked = "aom_food:baked_potato",
    input_count = 1, -- optional or 1
    output_count = 1, -- optional or 1
    cook_time = 2,
    groups = {"cooker_boil"},
})

minetest.register_alias("aom_items:baked_potato", "aom_food:baked_potato")



-- pumpkin soup
minetest.register_craftitem("aom_food:pumpkin_cooked", {
    description = S("Cooked Pumpkin"),
    inventory_image = "aom_pumpkin_cooked.png",
    groups = { item_wooden_bowl_pumpkin_soup = 1, craftitem = 1, food = 1, },
})
aom_util.register_wield_use_delay("aom_food:pumpkin_cooked", {
    windup = 2,
    sound = {
        name = "aom_food_munch",
        gain = 0.2,
        max_hear_distance = 10,
        pitch = 0.85
    },
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["regeneration_3"] = 3*2+1,
        ["regeneration_8"] = 8*4+1,
    })
})
aom_cooking.register_cooking({
    raw = "aom_flora:pumpkin",
    cooked = "aom_food:pumpkin_cooked",
    input_count = 1, -- optional or 1
    output_count = 1, -- optional or 1
    cook_time = 4,
    groups = {"cooker_boil"},
})




minetest.register_craftitem("aom_food:cooked_animal_meat", {
    description = S("Animal Meat"),
    inventory_image = "aom_cooked_animal_meat.png",
    groups = { item_cooked_animal_meat = 1, craftitem = 1, food = 1, },
})
aom_util.register_wield_use_delay("aom_food:cooked_animal_meat", {
    windup = 2,
    sound = {
        name = "aom_food_munch",
        gain = 0.2,
        max_hear_distance = 10,
        pitch = 0.85
    },
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["regeneration_1"] = 4,
        ["regeneration_3"] = 3*4+1,
        ["regeneration_8"] = 8*4+1,
      })
})
aom_cooking.register_cooking({
  raw = "aom_animals:animal_meat",
  cooked = "aom_food:cooked_animal_meat",
  input_count = 1,
  output_count = 1,
  cook_time = 4,
  groups = {"cooker_boil", "cooker_spit"},
})
minetest.register_alias("aom_animals:cooked_animal_meat", "aom_food:cooked_animal_meat")