
```lua
local my_menu = {
    name = "my_menu_name",
    -- signals that something was selected
    on_select = function(self, player, selection_name, pi)
        -- it's your responsibility to do with this info as you will, e.g. using lookup instead of if-else heresy
        if selection_name == "first_thing" then
            do_first_thing()
        elseif selection_name == "second_thing" then
            do_second_thing()
        else
            -- it was closed without selecting anything
        end
    end,
    -- for after all segments added
    after_init_huds = function(self, player, pi)
    end,
    -- for each segment added
    on_segment_added = function(self, player, pi, i, dir, pos)
    end,
    -- return true to allow selection to finish
    on_step = function(self, player, dtime, selection_name, pi)
        local is_using_radial = true
        if is_using_radial == false then
            return true -- close and select
        elseif is_using_radial == nil then
            return false -- do nothing keep open
        else
            return nil -- close and do nothing
        end
    end,
    -- the list of items to add, in order from left, clockwise
    items = {
        {name = "first_thing", image = "aom_icon_full.png", text = nil, scale = 0.75},
        {name = "second_thing", image = "aom_icon_stair.png", text = nil, scale = 0.75},
    }
}

[...]
aom_radial.show_radial_menu(player, my_menu)
```

## `pi`
This is a table used internally to keep track of hud ids and etc. You can (carefully) use this to store extra information about the player's selection and so on.

## `my_menu.items`
`scale` is the hud scale for that thing. If you want the result to occupy 32x32 of the screen and the texture in `items[i].image` is 16x16, use a scale of `2` here.

`text` is a label to show over the top of the radial segment.

`name` is the `selection_name` given to the callbacks.

