local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


local function on_load(itemstack, user)
    minetest.sound_play(("aom_muskets_pistol_cocked"), {
        gain = 0.15,
        pos = user:get_pos(),
        object = user,
        pitch = (math.random()*0.1) + 0.90
    })
end

local function use_musket(itemstack, user, pointed_thing)
    if not user:is_player() then return itemstack end
    local ret = aom_util.try_rightclick(itemstack, user, pointed_thing, false)
    if ret then
        return ret
    end

    aom_muskets.start_reload(user)

    if itemstack:get_wear() > 0 then
        minetest.sound_play(("aom_muskets_pistol_empty"), {
            gain = 1.5,
            pos = user:get_pos(),
            object = user,
            pitch = (math.random()*0.1) + 0.90
        })
        return itemstack
    end

    itemstack:set_name("aom_muskets:blunderbuss")
    itemstack:set_wear(65536 - 1)

    local dir = user:get_look_dir()
    local pos = user:get_pos()

    pos = aom_muskets.get_eyepos(user)
    -- pos = vector.add(pos, dir)
    local yawoffset = minetest.yaw_to_dir(user:get_look_horizontal() - 1)
    yawoffset = vector.multiply(yawoffset, 0.2)
    local bullet_pos = pos --vector.add(pos, yawoffset)
    local d = 0.18
    for i = 1, 5 do
        local bdir
        if true then
            bdir = vector.offset(dir, (math.random()*d)-(d/2), (math.random()*d)-(d/2), (math.random()*d)-(d/2))
        end
        local ent = minetest.add_entity(bullet_pos, "aom_muskets:musket_shot_ENTITY"):get_luaentity()
        ent._shooter = user
        ent._damage = {pierce = 8, projectile = 1}
        ent._dir = bdir
        ent._bullet_drop = -40
        ent._speed = 400
        ent._lifetime = 0.2
        -- ent._last_pos = pos
    end
    minetest.sound_play(("aom_muskets_pistol"), {
        gain = 1.5,
        pos = bullet_pos,
        object = user,
        max_hear_distance = 200,
        pitch = (math.random()*0.1) + 0.60
    })
    minetest.sound_play(("aom_muskets_pistol"), {
        gain = 1.5,
        pos = bullet_pos,
        object = user,
        max_hear_distance = 100,
        pitch = (math.random()*0.1) + 0.90
    })
    local particle_pos = vector.add(pos, vector.multiply(dir, 1.4))
    particle_pos = vector.add(particle_pos, yawoffset)
    aom_muskets.do_smoke_particles(particle_pos, 5, dir, 13, 0.5)
    aom_muskets.do_smoke_particles(particle_pos, 10, dir, 8, 0.3)
    aom_muskets.do_particles(particle_pos, 5)
    local flashnode = minetest.get_node(bullet_pos)
    if flashnode.name == "air" then
        minetest.set_node(bullet_pos, {name="aom_util:light_node_14"})
        minetest.get_node_timer(bullet_pos):set(1,0.8)
    end
    return itemstack
end

minetest.register_tool("aom_muskets:blunderbuss", {
    description = S("Flintlock Blunderbuss"),
    _tt_color = 3,
    _tt_long_desc = S("Slow, shoots buckshot."),
    _tt_how_to_use = S("Fire: [place node]").."\n"..S("Reload: 3-7s"),
    _tt_uses = "Infinite",
    inventory_image = "aom_muskets_blunderbuss_loaded.png",
    wield_image = "aom_muskets_blunderbuss.png^[transform3",
    wield_scale = {x=8.0/3,y=5.0/3,z=4.0},
    tool_capabilities = {
        damage_groups = {
            blunt=2,
        },
    },
    groups = { musket = 1 },
    on_secondary_use = use_musket,
    on_place = use_musket,
    _wield3d_textures = "aom_muskets:blunderbuss_loaded",
    _wield3d_offset =   {x=-0.7, y=4.0, z=-2.3},
    _wield3d_scale = {x=0.12, y=0.12, z=0.12},
    _override_item_entity = {
        visual_size = {x=0.12, y=0.12, z=0.12},
    },
})
minetest.register_tool("aom_muskets:blunderbuss_loaded", {
    description = S("Flintlock Blunderbuss"),
    _tt_color = 3,
    _tt_long_desc = S("Slow, shoots buckshot."),
    _tt_how_to_use = S("Fire: [place node]").."\n"..S("Reload: 3-7s"),
    _tt_uses = "Infinite",
    inventory_image = "aom_muskets_blunderbuss.png",
    wield_image = "aom_muskets_blunderbuss_wield.png",
    wield_scale = {x=5.0,y=4.0,z=4.0},
    tool_capabilities = {
        damage_groups = {
            blunt=2,
        },
    },
    groups = { musket = 1 },
    on_secondary_use = use_musket,
    on_place = use_musket,
    _wield3d_offset =   {x=-0.7, y=4.0, z=-2},
    _wield3d_scale = {x=0.16, y=0.16, z=0.16},
    _override_item_entity = {
        visual_size = {x=0.16, y=0.16, z=0.16},
    },
})
if aom_vars.technology_level >= 4 then
    aom_tcraft.register_group_craft({
        output = "aom_muskets:blunderbuss_loaded",
        items = {
            ["aom_muskets:pistol_loaded"]=1,
            ["aom_items:iron_bar"]=5,
        },
        group = "planks",
        group_count = 4
    })
    local s = "aom_muskets:blunderbuss"
    minetest.register_craft({
        output = "aom_muskets:blunderbuss_loaded",
        recipe = {
        {s},
        },
    })
end

aom_muskets.register_musket_reloader({
    name = "aom_muskets:blunderbuss",
    time = 5,
    loaded = "aom_muskets:blunderbuss_loaded",
    on_load = on_load,
    require_wield = true,
    sneak_boost = 1.0,
    sprint_boost = 1.0,
    -- movement_speed = 0,
    auto_reload = true,
})

aom_util.register_on_wield({
    name = "aom_muskets:blunderbuss_loaded",
    on_change_to_item = function(player)
        aom_muskets.start_reload(player)
        player_model.set_anim(player, {tag="aom_muskets_aim", actions={"aim"}})
    end,
    on_change_from_item = function(player)
        player_model.unset_anim(player, "aom_muskets_aim")
    end,
})
