local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local sealevel = aom_underworld.sea_level
local alt_max = aom_underworld.alt_max
local alt_min = aom_underworld.alt_min

local this_biome = "underworld_coral"

local size = 70
------------------------------------------------
------- FLORA
------------------------------------------------
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:lava_coral",
    wherein        = {"aom_underworld:worknode_topsoil"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
        offset = alt_min + alt_max / 2,
        scale = math.abs(alt_max - alt_min) * 2,
        spread = {x = size, y = size, z = size},
        seed = 78686,
        octaves = 5,
    },
    np_stratum_thickness = {
        offset = 150,
        scale = 800,
        spread = {x = 100, y = 100, z = 100},
        seed = 325,
        octaves = 3,
        persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = { this_biome },
})
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:lava_coral_top",
    wherein        = {"aom_underworld:lava_coral"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
        offset = alt_min + alt_max / 2,
        scale = math.abs(alt_max - alt_min) * 2,
        spread = {x = size, y = size, z = size},
        seed = 231,
        octaves = 5,
    },
    np_stratum_thickness = {
        offset = 200,
        scale = 100,
        spread = {x = 100, y = 100, z = 100},
        seed = 765,
        octaves = 3,
        persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = { this_biome },
})
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:lava_coral_sparse",
    wherein        = {"aom_underworld:worknode_topsoil"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
        offset = alt_min + alt_max / 2,
        scale = math.abs(alt_max - alt_min) * 2,
        spread = {x = size, y = size, z = size},
        seed = 78686,
        octaves = 5,
    },
    np_stratum_thickness = {
        offset = -20,
        scale = 500,
        spread = {x = 100, y = 100, z = 100},
        seed = 325,
        octaves = 3,
        persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = { this_biome },
})
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:lava_coral_top",
    wherein        = {"aom_underworld:lava_coral"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
        offset = alt_min + alt_max / 2,
        scale = math.abs(alt_max - alt_min) * 2,
        spread = {x = 50, y = 50, z = 50},
        seed = 3753,
        octaves = 5,
    },
    np_stratum_thickness = {
        offset = 100,
        scale = 500,
        spread = {x = 10, y = 10, z = 10},
        seed = 435,
        octaves = 3,
        persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = { this_biome },
})
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:lava_coral_sparse",
    wherein        = {"aom_underworld:lava_coral"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
        offset = alt_min + alt_max / 2,
        scale = math.abs(alt_max - alt_min) * 2,
        spread = {x = 30, y = 30, z = 30},
        seed = 876,
        octaves = 5,
    },
    np_stratum_thickness = {
        offset = 600,
        scale = 200,
        spread = {x = 10, y = 10, z = 10},
        seed = 23,
        octaves = 3,
        persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = { this_biome },
})

minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:lava_rock_coral",
    wherein        = {"aom_underworld:worknode_topsoil"},
    y_min = aom_underworld.alt_min,
    y_max = aom_underworld.alt_max,
    biomes = {"underworld_coral"}
})

minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:fog",
    wherein        = {"aom_underworld:worknode_dust", "aom_underworld:worknode_ceiling"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
      offset = alt_min + alt_max / 2,
      scale = math.abs(alt_max - alt_min),
      spread = {x = 50, y = 50, z = 50},
      seed = 765,
      octaves = 5,
    },
    np_stratum_thickness = {
      offset = 100,
      scale = 80,
      spread = {x = 40, y = 40, z = 40},
      seed = 654,
      octaves = 3,
      persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = {"underworld_coral"},
})
