
---Pretend a `point` is stuck to or relative to some object with `yaw`
local UP = vector.new(0,1,0)
function aom_vehicleapi.rotate_point(point, yaw)
    return vector.rotate_around_axis(point, UP, yaw)
end

---Distance without square root
function aom_vehicleapi.squaredist(p1, p2)
    return (p1.x-p2.x)^2 + (p1.y-p2.y)^2 + (p1.z-p2.z)^2
end

---Distance from zero, for directions and offsets
function aom_vehicleapi.squarezerodist(p1)
    return (p1.x)^2 + (p1.y)^2 + (p1.z)^2
end

---Returns 1 or -1 or 0
function aom_vehicleapi.get_sign(v)
    return (v==0 and 0) or (v>0 and 1) or -1
end

function aom_vehicleapi.clamp(v, m, n)
    return math.min(n, math.max(v, m))
end

-- function aom_vehicleapi.shortangledist(a0, a1)
--     local max = math.pi * 2
--     local da = (a1 - a0) % max
--     return 2 * da % max - da
-- end

function aom_vehicleapi.shortangledist(a0, a1)
    return ((((a1 - a0) % (math.pi*2)) + (math.pi*3)) % (math.pi*2)) - math.pi
end

function aom_vehicleapi.anglelerp(a0, a1, t)
    return a0 + aom_vehicleapi.shortangledist(a0, a1) * t
end

function aom_vehicleapi.lerp(a, b, f)
    return (1 - f) * a + f * b
end
