local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


local function on_load(itemstack, user)
    minetest.sound_play(("aom_muskets_pistol_cocked"), {
        gain = 0.15,
        pos = user:get_pos(),
        object = user,
        pitch = (math.random()*0.1) + 0.90
    })
end

local function use_musket(itemstack, user, pointed_thing)
    if not user:is_player() then return itemstack end
    local ret = aom_util.try_rightclick(itemstack, user, pointed_thing, false)
    if ret then
        return ret
    end

    if itemstack:get_wear() > 0 then
        minetest.sound_play(("aom_muskets_pistol_empty"), {
            gain = 1.5,
            pos = user:get_pos(),
            object = user,
            pitch = (math.random()*0.1) + 0.90
        })
        aom_muskets.start_reload(user)
        return itemstack
    end

    itemstack:set_name("aom_muskets:rifle")
    itemstack:set_wear(65536 - 1)

    local dir = user:get_look_dir()
    if true then
        local d = 0.005
        dir = vector.offset(dir, (math.random()*d)-(d/2), (math.random()*d)-(d/2), (math.random()*d)-(d/2))
    end
    local pos = user:get_pos()

    pos = aom_muskets.get_eyepos(user)
    -- pos = vector.add(pos, dir)
    local yawoffset = minetest.yaw_to_dir(user:get_look_horizontal() - 1)
    yawoffset = vector.multiply(yawoffset, 0.2)
    local bullet_pos = pos --vector.add(pos, yawoffset)
    local ent = minetest.add_entity(bullet_pos, "aom_muskets:musket_shot_ENTITY"):get_luaentity()
    ent._shooter = user
    ent._damage = {pierce = 20, projectile = 1}
    ent._dir = dir
    ent._speed = 300
    ent._bullet_drop = -20
    ent._lifetime = 1.5
    -- ent._last_pos = pos
    minetest.sound_play(("aom_muskets_pistol"), {
        gain = 0.5,
        -- pos = object:get_pos(),
        object = user,
        max_hear_distance = 200,
        pitch = (math.random()*0.1) + 0.60
    })
    minetest.sound_play(("aom_muskets_pistol"), {
        gain = 1.5,
        pos = bullet_pos,
        object = user,
        max_hear_distance = 100,
        pitch = (math.random()*0.1) + 1.9
    })

    local particle_pos = vector.add(pos, vector.multiply(dir, 2.4))
    particle_pos = vector.add(particle_pos, yawoffset)
    aom_muskets.do_smoke_particles(particle_pos, 20, dir, 6, 0.1)
    aom_muskets.do_particles(particle_pos, 10)
    local flashnode = minetest.get_node(bullet_pos)
    if flashnode.name == "air" then
        minetest.set_node(bullet_pos, {name="aom_util:light_node_14"})
        minetest.get_node_timer(bullet_pos):set(1,0.8)
    end
    return itemstack
end

minetest.register_tool("aom_muskets:rifle", {
    description = S("Flintlock Rifle"),
    _tt_color = 3,
    _tt_long_desc = S("Slow to reload but very accurate and powerful."),
    _tt_how_to_use = S("Fire: [place node]").."\n"..S("Reload: 4-8s"),
    _tt_uses = "Infinite",
    inventory_image = "aom_muskets_rifle_loading.png",
    wield_image = "aom_muskets_rifle.png^[transform3",
    wield_scale = {x=8.0/3,y=5.0/3,z=4.0},
    tool_capabilities = {
        damage_groups = {
            blunt=2,
        },
    },
    groups = { musket = 1, not_in_creative_inventory = 1, },
    on_secondary_use = use_musket,
    on_place = use_musket,
    _wield3d_textures = "aom_muskets:rifle_loaded",
    _wield3d_offset =   {x=-0.7, y=2.0, z=-2.3},
    _wield3d_scale = {x=0.12, y=0.12, z=0.12},
    _wield3d_rotation = {x=-90, y=45+12, z=-90},
    _override_item_entity = {
        visual_size = {x=0.12, y=0.12, z=0.12},
    },
})
local on_fire = function(itemstack, player)
    local ctrl = player:get_player_control()
    if ctrl and not ctrl.sneak then
        return use_musket(itemstack, player)
    end
end
minetest.register_tool("aom_muskets:rifle_loaded", {
    description = S("Flintlock Rifle"),
    _tt_color = 3,
    _tt_long_desc = S("Slow to reload but very accurate and powerful."),
    _tt_how_to_use = S("Fire: [place node]").."\n"..S("Reload: 4-8s"),
    _tt_uses = "Infinite",
    inventory_image = "aom_muskets_rifle.png",
    wield_image = "aom_muskets_rifle_wield.png",
    wield_scale = {x=5,y=4,z=3.0},
    tool_capabilities = {
        damage_groups = {
            blunt=2,
        },
    },
    groups = { musket = 1 },
    -- on_use = use_musket,
    on_secondary_use = on_fire,
    on_place = on_fire,
    _wield3d_offset =   {x=-0.7, y=6.0, z=-2.0},
    _wield3d_scale = {x=0.2, y=0.2, z=0.2},
    _wield3d_rotation = {x=-90, y=45-7, z=-90},
    _override_item_entity = {
        visual_size = {x=0.24, y=0.24, z=0.24},
    },
})
if aom_vars.technology_level >= 4 then
    local g = "aom_muskets:pistol_loaded"
    local b = "aom_items:iron_bar"
    minetest.register_craft({
        output = "aom_muskets:rifle_loaded",
        recipe = {
        {g, b, b},
        },
    })
end

aom_muskets.register_musket_reloader({
    name = "aom_muskets:rifle",
    time = 5,
    loaded = "aom_muskets:rifle_loaded",
    on_load = on_load,
    on_step = function(player, dtime, itemstack)
        return aom_muskets.on_step_quick_reload(player, dtime, itemstack, {min=7, max=10})
    end,
    require_wield = true,
    sneak_boost = 1.0,
    sprint_boost = 1.0,
    movement_speed = 0.4,
    auto_reload = false,
})

aom_util.register_on_wield({
    name = "aom_muskets:rifle_loaded",
    on_change_to_item = function(player)
        aom_util.unset_fov(player, "aom_muskets:rifle_zoom")
        aom_muskets.start_reload(player)
        player_model.set_anim(player, {tag="aom_muskets_aim", actions={"aim"}})
    end,
    on_change_from_item = function(player)
        aom_util.unset_fov(player, "aom_muskets:rifle_zoom")
        player_model.unset_anim(player, "aom_muskets_aim")
    end,
    on_step = function(player, dtime, itemstack)
        local ctrl = aom_playerapi.controls.get_player_control(player)
        if ctrl and ctrl.pressed.sneak and ctrl.pressed.place then
            aom_util.set_fov(player, {
                tag = "aom_muskets:rifle_zoom",
                fov = 0.4,
                is_multiplier = true,
                transition_time = 0.2 })
        elseif aom_util.has_fov(player, "aom_muskets:rifle_zoom") ~= nil then
            aom_util.unset_fov(player, "aom_muskets:rifle_zoom")
        end
        if ctrl and ctrl.just_released.place and ctrl.pressed.sneak then
            player:set_wielded_item(use_musket(player:get_wielded_item(), player))
        end
    end,
})

aom_util.register_on_wield({
    name = "aom_muskets:rifle",
    on_change_to_item = function(player)
        player_model.set_anim(player, {tag="aom_muskets_reload", actions={"aim"}})
    end,
    on_change_from_item = function(player)
        player_model.unset_anim(player, "aom_muskets_reload")
    end,
    on_step = function(player, dtime, itemstack)
        if itemstack:get_wear() < 65536 - 10 then
            player_model.set_anim(player, {tag="aom_muskets_reload", actions={"sneak", "aim"}})
        end
    end,
})
