local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


aom_food = {}
aom_food.sound = {}

function aom_food.sound.munch(def) if not def then def = {} end
    return {
        name = "aom_food_munch",
        gain = def.gain or 0.8,
        max_hear_distance = def.max_hear_distance or 10,
        pitch = def.pitch or 1
    }
end
function aom_food.sound.gulp(def) if not def then def = {} end
    return {
        name = "aom_food_gulp",
        gain = def.gain or 0.9,
        max_hear_distance = def.max_hear_distance or 10,
        pitch = def.pitch or 1
    }
end

function aom_food.eat(effects, leftover_itemstring, soundspec)
    return function(itemstack, user, pointed_thing)
        local name = user and user:get_player_name()
        for effect, duration in pairs(effects) do
            aom_statusfx.apply_status(user, effect, duration, {})
        end
        if not minetest.is_creative_enabled(name) then
            itemstack:take_item(1)
            local leftover = ItemStack(leftover_itemstring)
            if itemstack:get_count() == 0 then
                itemstack = leftover
                leftover = nil
            end
            if leftover then
                leftover = leftover
                leftover = user:get_inventory():add_item("main", leftover)
            end
            if leftover then
                minetest.add_item(user:get_pos(), leftover)
            end
        end
        if not soundspec then soundspec = aom_food.sound.munch()
        else soundspec = table.copy(soundspec) end
        soundspec.object = user
        minetest.sound_play(soundspec.name, soundspec)
        return itemstack
    end
end


dofile(mod_path .. "/items" .. "/just_cooked.lua")
dofile(mod_path .. "/items" .. "/soups.lua")

