local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)


minetest.register_node('aom_stone:limestone_brick', {
    description = S("Limestone Brick"),
    groups = { full_solid = 1, limestone = 1, material_limestone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_stone_limestone_brick.png"},
    sounds = aom_sounds.default_stone(),
})
if true then
    local g = "aom_stone:limestone"
    minetest.register_craft({
        output = "aom_stone:limestone_brick 4",
        recipe = {
        {g, g},
        {g, g},
        },
    })
end
aom_util.register_all_shapes("aom_stone:limestone_brick")


minetest.register_node('aom_stone:limestone_brick_fine', {
    description = S("Fine Limestone Brick"),
    groups = { full_solid = 1, limestone = 1, material_limestone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_stone_limestone_brick_fine.png"},
    sounds = aom_sounds.default_stone(),
})
if true then
    local s = "aom_stone:limestone"
    local g = "aom_stone:limestone_brick"
    minetest.register_craft({
        output = "aom_stone:limestone_brick_fine 6",
        recipe = {
        {s, s},
        {g, g},
        {g, g},
        },
    })
end
aom_util.register_all_shapes("aom_stone:limestone_brick_fine")


minetest.register_node('aom_stone:limestone_brick_pillar', {
    description = S("Limestone Brick Pillar"),
    groups = { full_solid = 1, limestone = 1, material_limestone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_stone_limestone_brick_pillar_top.png", "aom_stone_limestone_brick_pillar_top.png", "aom_stone_limestone_brick_pillar.png"},
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    on_place = aom_util.rotate_and_place,
})
if true then
    local g = "aom_stone:limestone_brick"
    minetest.register_craft({
        output = "aom_stone:limestone_brick_pillar 3",
        recipe = {
        {g},
        {g},
        {g},
        },
    })
end
aom_util.register_all_shapes("aom_stone:limestone_brick_pillar")


minetest.register_node('aom_stone:limestone_brick_ornate', {
    description = S("Limestone Brick Ornate"),
    groups = { full_solid = 1, limestone = 1, material_limestone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {"aom_stone_limestone_brick_ornate.png"},
    sounds = aom_sounds.default_stone(),
})
if true then
    local g = "aom_stone:limestone_brick"
    minetest.register_craft({
        output = "aom_stone:limestone_brick_ornate 4",
        recipe = {
        {g, g},
        {g, g},
        },
    })
end
aom_util.register_all_shapes("aom_stone:limestone_brick_ornate")


minetest.register_node('aom_stone:limestone_brick_lamp', {
    description = S("Limestone Brick Lamp"),
    groups = { full_solid = 1, limestone = 1, material_limestone_lamp = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = aom_util.node_light_unfck("aom_stone_limestone_brick_lamp.png"),
    sounds = aom_sounds.default_stone(),
    light_source = 14,
    paramtype = "light",
})
if true then
    local g = "aom_stone:limestone_brick_ornate"
    local l = "aom_lights:torch"
    minetest.register_craft({
        output = "aom_stone:limestone_brick_lamp 1",
        recipe = {
        {l},
        {g},
        },
    })
end
aom_util.register_all_shapes("aom_stone:limestone_brick_lamp")


local function place_long_brick(itemstack, placer, pointed_thing)
    local name = itemstack:get_name()
    local def = minetest.registered_nodes[name]
    if minetest.get_node(pointed_thing.under).name == name then
        itemstack:set_name(def._alternate)
        itemstack = minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true}, nil)
        itemstack:set_name(name)
    else
        itemstack = minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true}, nil)
    end
    return itemstack
end

minetest.register_node('aom_stone:limestone_brick_left', {
    description = S("Double Limestone Brick (left)"),
    _tt_long_desc = S("The Left side of a long brick."),
    groups = { full_solid = 1, limestone = 1, material_limestone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        -- top
        "aom_stone_limestone_brick_long_end_left.png",
        -- bottom
        "aom_stone_limestone_brick_long_end_left.png",
        -- right / east
        "aom_stone_limestone_brick_long_top.png",
        -- left / west
        "aom_stone_limestone_brick_long_top.png",
        -- behind / north (facedir)
        "aom_stone_limestone_brick_long_end_right.png",
        -- front / south (pointing at player)
        "aom_stone_limestone_brick_long_end_left.png",
    },
    inventory_image = "aom_stone_limestone_brick_long_inv.png^aom_stone_brick_long_inv_L.png",
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    _alternate = "aom_stone:limestone_brick_right",
    on_place = place_long_brick,
})
if true then
    local g = "aom_stone:limestone_brick"
    minetest.register_craft({
        output = "aom_stone:limestone_brick_left 2",
        recipe = {
        {g, g},
        },
    })
end
minetest.register_node('aom_stone:limestone_brick_right', {
    description = S("Double Limestone Brick (right)"),
    _tt_long_desc = S("The right side of a long brick."),
    groups = { full_solid = 1, limestone = 1, material_limestone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        -- top
        "aom_stone_limestone_brick_long_end_right.png",
        -- bottom
        "aom_stone_limestone_brick_long_end_right.png",
        -- right / east
        "aom_stone_limestone_brick_long_top.png",
        -- left / west
        "aom_stone_limestone_brick_long_top.png",
        -- behind / north (facedir)
        "aom_stone_limestone_brick_long_end_left.png",
        -- front / south (pointing at player)
        "aom_stone_limestone_brick_long_end_right.png",
    },
    inventory_image = "aom_stone_limestone_brick_long_inv.png^aom_stone_brick_long_inv_L.png",
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    _alternate = "aom_stone:limestone_brick_left",
    drop = "aom_stone:limestone_brick_left",
    on_place = place_long_brick,
})
minetest.register_craft({
    output = "aom_stone:limestone_brick_right",
    recipe = {
    {"aom_stone:limestone_brick_left"},
    },
})
minetest.register_craft({
    output = "aom_stone:limestone_brick_left",
    recipe = {
    {"aom_stone:limestone_brick_right"},
    },
})
