local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

aom_fire = {}


function aom_fire.spread(pos, node)
  aom_util.did_abm("fire")
  if not node then node = minetest.get_node(pos) end
  if math.random() < 0.1 then -- random chance to go out
    minetest.dig_node(pos)
    return nil
  end
  local nodes = minetest.find_nodes_in_area_under_air(
    vector.offset(pos, -1, -1, -1),
    vector.offset(pos,  1,  2,  1),
    {"group:flammable"})
  local spread_pos = nil
  for noderef, value in pairs(nodes) do
    if true then
      spread_pos = value
      break
    end
  end
  if not spread_pos then
    return false
  end
  spread_pos = vector.offset(spread_pos, 0, 1, 0)
  if minetest.get_node(spread_pos).name == "air" then
    minetest.set_node(spread_pos, {name=node.name})
  end
end

function aom_fire.burn_up_node(pos)
  aom_util.did_abm("fire")
  if math.random() > 0.8 then return end
  local below = minetest.get_node(vector.offset(pos, 0, -1, 0))
  local is_above_flammable = (minetest.get_item_group(below.name, "flammable") ~= 0)
  if not is_above_flammable then
    minetest.dig_node(pos)
  elseif is_above_flammable then
    if below.name == "aom_wood:hot_coals" then
      minetest.dig_node(pos)
      if math.random() < 0.1 then
        local above = minetest.get_node_or_nil(vector.offset(pos, 0, 1, 0))
        if above and above.name ~= "air" then
          minetest.set_node(vector.offset(pos, 0, -1, 0), {name = "aom_fire:fire"})
        end
      end
    elseif minetest.get_item_group(below.name, "wood_log") == 0
    and below.name ~= "aom_wood:charcoal_block"
    and math.random() < 0.7 then
      minetest.set_node(vector.offset(pos, 0, -1, 0), {name = "aom_fire:fire"})
      minetest.dig_node(pos)
    elseif math.random() < 0.4 then
      minetest.set_node(vector.offset(pos, 0, -1, 0), {name = "aom_wood:hot_coals"}) -- aom_wood:charcoal_block
    end
  end
end


local fire_size = {
  type = "fixed",
  fixed = {-4/16, -8/16, -4/16, 4/16, 3/16, 4/16},}

minetest.register_node('aom_fire:fire', {
  -- TL: flames node
  description = S("Fire"),
  _tt_color = 6,
  groups = { item_fire = 1, nature = 1, dig_immediate = 1, fire = 1, lights_fires = 1, spreads_fire = 1, not_in_creative_inventory = 1, },
    drawtype = "mesh",
  use_texture_alpha = "clip",
    tiles = {{
            name = "aom_fire.png", -- this is the flame texture
            animation = {
                type = "vertical_frames",
                aspect_w = 16,
                aspect_h = 16,
                length = 0.5,
            },},},
  drop = "",
  selection_box = fire_size,
  walkable = false,
  damage_per_second = 4,
  buildable_to = true,
    mesh = "aom_fire.b3d",
  light_source = 12,
  paramtype = "light",
  sounds = (aom_sounds.default and aom_sounds.default_stone()),
    collision_box = nil,
  on_punch = function(pos, node, clicker, itemstack, pointed_thing)
    minetest.dig_node(pos)
  end,
  on_timer = function(pos, elapsed)
    aom_fire.spread(pos)
    aom_fire.burn_up_node(pos)
    if minetest.get_node(pos).name == "aom_fire:fire" then
      local nt = minetest.get_node_timer(pos)
      nt:start(math.random()*8 + 3)
    end
  end,
  on_construct = function(pos)
    local nt = minetest.get_node_timer(pos)
    nt:start(math.random()*8 + 3)
  end
})

-- spread fire
minetest.register_abm({
  nodenames = {"group:spreads_fire"},
  neighbors = {"group:flammable"},
  interval = 20.0,
  chance = 20,
  action = aom_fire.spread,
})

