local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node("aom_fengold:gilded_stone_brick", {
    description = S("Gilded Stone"),
    _tt_color = 2,
    groups = { nature = 1, material_gilded_stone = 1, full_solid = 1, gilded = 1,
               stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        "aom_fengold_stone_brick_gold.png",
    },
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_fengold:gilded_stone_brick")

minetest.register_craft({
    output = "aom_fengold:gilded_stone_brick",
    type = "shapeless",
    recipe = { "aom_stone:stone_brick", "aom_fengold:gold_gilding"},
})




minetest.register_node("aom_fengold:gilded_stone_brick_ornate", {
    description = S("Gilded Stone Ornate"),
    _tt_color = 2,
    groups = { nature = 1, material_gilded_stone = 1, full_solid = 1, gilded = 1,
               stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        "aom_fengold_stone_ornate_gold_top.png",
        "aom_fengold_stone_ornate_gold_top.png",
        "aom_fengold_stone_ornate_gold.png",
    },
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_fengold:gilded_stone_brick_ornate", nil, {no_world_align = true})

if true then
    local a = "aom_stone:stone_brick"
    local g = "aom_fengold:gold_gilding"
    minetest.register_craft({
        output = "aom_fengold:gilded_stone_brick_ornate 4",
        recipe = {
            {g,g},
            {a,a},
            {a,a},
        },
    })
end




minetest.register_node("aom_fengold:gilded_stone_pillar", {
    description = S("Gilded Stone Pillar"),
    _tt_color = 2,
    groups = { nature = 1, material_gilded_stone = 1, full_solid = 1, gilded = 1,
               stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        "aom_fengold_stone_pillar_gold_top.png",
        "aom_fengold_stone_pillar_gold_top.png",
        "aom_fengold_stone_pillar_gold.png",
    },
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    on_place = aom_util.rotate_and_place,
})
aom_util.register_all_shapes("aom_fengold:gilded_stone_pillar", nil, {no_world_align = true})

if true then
    local g = "aom_fengold:gilded_stone_brick"
    minetest.register_craft({
        output = "aom_fengold:gilded_stone_pillar 3",
        recipe = {
            {g},
            {g},
            {g},
        },
    })
end



