local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

aom_climate = {}

aom_climate.mod_storage = minetest.get_mod_storage()

function aom_climate.debug_particle(pos, color, time, vel, size)
    -- do return end -- for debug purposes
    minetest.add_particle({
        size = size or 2,
        pos = pos,
        texture = "white.png^[colorize:"..(color or "#fff")..":255",
        velocity = vel or vector.new(0, 0, 0),
        expirationtime = time,
        glow = 14,
    })
end

aom_climate.has_aom_settings = minetest.get_modpath("aom_settings") ~= nil

if aom_climate.has_aom_settings then
    -- TL: setting description
    aom_settings.register_setting("climate_wind_particles_server", true, S("Show wind particles"), "server")
    -- TL: setting description
    aom_settings.register_setting("climate_wind_particles", true, S("Show wind particles"))
    -- TL: setting description
    aom_settings.register_setting("climate_wind_volume", 1, S("Wind sound volume"))
end

function aom_climate.get_setting(player, key, default)
    if aom_climate.has_aom_settings then
        return aom_settings.get_setting(player, key, default)
    else
        return default
    end
    return default
end

dofile(mod_path .. "/scripts/math.lua")
dofile(mod_path .. "/scripts/helpers.lua")
-- wind
dofile(mod_path .. "/scripts/wind.lua")
dofile(mod_path .. "/scripts/wind_sound.lua")
dofile(mod_path .. "/scripts/wind_particles.lua")
dofile(mod_path .. "/scripts/wind_clouds.lua")
