
local function tmpfix(pos, formname, fields, player)
    local meta = core.get_meta(pos)
    local node_formname = meta:get_string("formname")
    if node_formname ~= "" then
        formname = node_formname
    else
        formname = "nodemeta:"..pos.x..","..pos.y..","..pos.z
    end
    if not core.is_player(player) then return end
    for _, func in ipairs(core.registered_on_player_receive_fields) do
        if func(player, formname, fields) == true then return end
    end
end

core.register_on_mods_loaded(function()
    for nodename, def in pairs(core.registered_nodes) do
        if def._has_formspec then
            local old_fields = def.on_receive_fields
            core.override_item(nodename, {
                on_receive_fields = function(pos, ...)
                    tmpfix(pos, ...)
                    if old_fields then return old_fields(pos, ...) end
                end
            })
        end
    end
end)
