local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node("aom_mirecaves:stone", {
    description = S("Mirestone"),
    groups = { nature = 1, item_mirestone = 1, full_solid = 1, mirecaves = 1, stone = 1, oddly_breakable_by_hand = 3, cracky = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_mirecaves_stone.png"},
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_mirecaves:stone")


minetest.register_node("aom_mirecaves:stone_moss", {
    description = S("Mirestone Moss"),
    groups = { nature = 1, item_stone_moss = 1, full_solid = 1, mirecaves = 1, stone = 1, oddly_breakable_by_hand = 3, cracky = 1, solid = 1, suffocates = 2 },
    tiles = {
        "aom_mirecaves_stone_moss_top.png",
        "aom_mirecaves_stone.png",
        "aom_mirecaves_stone.png^[colorize:#000000:50^aom_mirecaves_stone_moss_side.png",
    },
    drop = {
        max_items = 2,
        items = {
            {
                -- rarity = 1,
                items = {"aom_mirecaves:stone"},
            },
        },
    },
    sounds = aom_sounds.default_soil(),
    paramtype = "light",
    light_source = 4,
})

minetest.register_node("aom_mirecaves:stone_moss_glow", {
    description = S("Glowing Mirestone Moss"),
    groups = { nature = 1, item_stone_moss = 1, full_solid = 1, mirecaves = 1, stone = 1, oddly_breakable_by_hand = 3, cracky = 1, solid = 1, suffocates = 2 },
    tiles = {
        "aom_mirecaves_stone_moss_top.png",
        "aom_mirecaves_stone.png",
        "aom_mirecaves_stone.png^[colorize:#000000:60^aom_mirecaves_stone_moss_side.png",
    },
    drop = {
        max_items = 2,
        items = {
            {
                -- rarity = 1,
                items = {"aom_mirecaves:stone"},
            },
        },
    },
    sounds = aom_sounds.default_soil(),
    paramtype = "light",
    light_source = 3,
})

if true then
    local g = "aom_mirecaves:stone"
    local a = "aom_mirecaves:stone"
    minetest.register_craft({
        output = "aom_mirecaves:stone_moss 2",
        recipe = {
            {g},
            {a},
        },
    })
end