# Usage
Provides a centralised system for checking and setting gameplay tags etc.

There is no "register_gamemode", only the `add_gamemode_tags`.

Gamemodes are not run through this API, instead it serves as just a way to declare and compare gamemodes.

### Callbacks
```lua
aom_gamemodes.register_on_start_gamemode(gamemode:string, func:functionRef)
aom_gamemodes.register_on_end_gamemode(gamemode:string, func:functionRef)

```

### Setting the gamemode
```lua
aom_gamemodes.set_gamemode(player:objectRef, gamemode:string)

```
```lua
aom_gamemodes.get_gamemode(player:objectRef) --> string --> "survival"

```
```lua
aom_gamemodes.player_has_tag(player:objectRef, tag:string) --> bool

```
```lua
aom_gamemodes.get_gamemode_tags(gamemode:string) --> table --> {tag=true}

```
```lua
aom_gamemodes.add_gamemode_tags(gamemode:string, tags:table)
-- e.g.
aom_gamemodes.add_gamemode_tags("windmills", {
    -- inventory = true,
    -- crafting = false,
    damage = true,
    visible_to_mobs = true,
})
```
