
aom_playerapi.has_aom_settings = (core.get_modpath("aom_settings") ~= nil)
aom_playerapi.has_aom_statusfx = (core.get_modpath("aom_statusfx") ~= nil)

aom_playerapi._pl = {} -- player data (non-persistent)

function aom_playerapi.check_player(player)
    local pi = aom_playerapi._pl[player]
    if not pi then pi = {}; aom_playerapi._pl[player] = pi end
    return pi
end

local registered_player_steps = {}

function aom_playerapi.register_on_player_step(callback)
    table.insert(registered_player_steps, callback)
end

function aom_playerapi.on_player_step(player, dtime, pi)
    for i, callback in ipairs(registered_player_steps) do
        callback(player, dtime, pi)
    end
end
