local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

aom_credits = {}

---@diagnostic disable: undefined-field

aom_credits.form = aom_bform.element.form:new({24, 12}, 6, "credits")
aom_credits.form:add_children({
	aom_bform.element.container.new({24, 12}, {1,0}, "main"):add_children({
		aom_bform.element.listcolors.new("#f00", "#f00", "#f00"),
		aom_bform.element.listcolors.new("#00000010", nil, "#0ff"),
		aom_bform.element.custom.new(nil, "bgcolor", {"bgcolor[#00000000;neither]"}),
		-- headings text styles
		aom_bform.element.custom.new(nil, nil, {"style_type[label;font_size=*2;textcolor=#fea]"}),
		-- background
		aom_bform.element.image.new(
			{23.5, 12},"bform_bg_opaque.png^[multiply:#19181f^(bform_bg_outline.png^[multiply:#000)", nil, 28
		):set_ignore_spacing(true),

		aom_bform.element.container.new({24, 12}, {0,1}, "main_text"):set_expand(true):add_children({
			aom_bform.element.custom.new({0, 0}, nil, {
				"scroll_container[0,0.15;23,11.7;scroll;vertical;0.1]"
			}),
			aom_bform.element.spacer.new({0,0.25}),
			-- banner at top
			aom_bform.element.container.new({24, 2}, {1,0}, nil):add_children({
				aom_bform.element.container.new({6, 2}, {1,0}, nil):add_children({
					aom_bform.element.image.new({4,2}, "aom_title_2x1.png", nil, nil),
					aom_bform.element.image.new({2,2}, "aom_sumi.png", nil, nil),
				}),
			}):set_space_evenly(true),
			aom_bform.element.spacer.new({0,0.75}),
			-- main text area
			aom_bform.element.container.new({12, 20}, {0,1}, nil):add_children({
				aom_bform.element.label.new({1,0.5}, S("About"), {1,0.2}, nil),
				aom_bform.element.textarea.new({12, 7-0.5}, nil, "", table.concat({
					S("Thank you for playing Age of Mending!"), "\n",
					"\n",
					S("This project is where I built the majority of my skills as a game designer, developer and artist."), " ",
					S("I gave myself the goal of realising a challenging design task: make an intrinsically enjoyable sandbox game, where people feel motivated to build a meaningful world for themselves and others while exploring a new one."), " ",
					S("Age of Mending is a window into my process and efforts to bring that about."), " ",
					S("That goal may take some time to accomplish, and to some extent it is an experiment to see if it even can be accomplished."), "\n",
					"\n",
					S("Over the years, after sinking thousands of hours of work into the project and its design and lore, it has grown on me and become something personal and special to me that I want to preserve and share with the world."), "\n",
					"__________", "\n",
					S("Sumi, creator of Age of Mending"),
				}), true, nil),
				aom_bform.element.spacer.new(nil, {1, 0.3}),
				aom_bform.element.label.new({1,0.5}, S("Creator"), {1,0.2}, nil),
				aom_bform.element.textarea.new({12, 5.5-0.5}, nil, "", table.concat({
					"    Sumi    <https://codeberg.org/SumianVoice> <https://github.com/SumianVoice>", "\n",
					S("- game design and project direction"), "\n",
					S("- art direction and aesthetics"), "\n",
					S("- systems and gameplay programming"), "\n",
					S("- textures, models, animations"), "\n",
					S("- music, most sounds"), "\n",
					S("- lore, worldbuilding and backstory"), "\n",
					S("- items, nodes and tools"), "\n",
					S("- structures, biomes, map generation and environmental design"), "\n",
				}), true, nil),
				aom_bform.element.spacer.new(nil, {1, 0.3}),
				aom_bform.element.label.new({1,0.5}, S("Past Contributions"), {1,0.2}, nil),
				aom_bform.element.textarea.new({12, 7.5-0.5}, nil, "", table.concat({
					S("=== Possible Minetest Blockgame Team ==="), "\n",
					"    opfromthestart    <https://codeberg.org/opfromthestart>", "\n",
					S("- mob API and state system"), "\n",
					S("- early groundwork"), "\n",
					S("- added first tools"), "\n",
					"\n",
					"    cora    <https://codeberg.org/cora>", "\n",
					S("- created the first weather API"), "\n",
					"\n",
					"    iliekprogrammar", "\n",
					S("- got mapgen working for the first time in PMB"), "\n",
					"\n",
					S("=== General Contributions ==="), "\n",
					"    epCode / Seugy    <https://codeberg.org/epCode>", "\n",
					S("- improved deer animations"), "\n",
				}), true, nil),
				aom_bform.element.spacer.new(nil, {1, 0.3}),
				aom_bform.element.label.new({1,0.5}, S("Other Notable Contributions"), {1,0.2}, nil),
				aom_bform.element.textarea.new({12, 7-0.5}, nil, "", table.concat({
					"    GreenXenith", "\n",
					S("- maintainer of the Blender .b3d plugin; without this plugin, the game would have no mobs, and the player would be a flat sprite."), "\n",
					S("- helped with several bugs related to Blender -> Luanti workflow"), "\n",
					"\n",
					"    Neuromancer", "\n",
					S("- had the suggestion of making tree leaves colors more distinct; making ash more yellow and spruce more blueish"), "\n",
					"\n",
					"    Wuzzy", "\n",
					S("- creator of the playerphysics API, which is used in this project"), "\n",
					"\n",
					"    Various Freesound Users (see media licenses)", "\n",
					S("- source of several CC licensed sounds"), "\n",
				}), true, nil),
			}):set_offset({6, 0}),
			aom_bform.element.spacer.new(nil, {1, 0.6}),
			aom_bform.element.label.new({1,1}, S("Media licenses in verbose format:"), {4,0.2}, nil),
			aom_bform.element.container.new({24, 1}, {1,0}, nil):add_children({
				aom_bform.element.container.new({0.5, 0.5}, nil, nil),
				aom_bform.element.container.new({18, 10}, {0,1}, "media_license_area"),
			}),
			aom_bform.element.custom.new({0, 0}, nil, {
				"scroll_container_end[]",
				"scrollbaroptions[arrows=hide;smallstep=10"..
				";thumbsize=20;max=310]",
				"scrollbar[23.3,0;0.7,12;vertical;scroll;0]"
			}),
		}):set_absolute_pos({0,0}),
	}),
}):set_params({
	auth_enabled = false,
	send_on_update = false,
})

-- unneeded
--[[
minetest.register_chatcommand("credits", {
    params = "",
    description = "",
    privs = {},
    func = function(name, param)
		local player = core.get_player_by_name(name)
		if not player then return end
		aom_credits.form:show_form(player, false)
    end
})
--]]

do -- get the full list of media licenses and all the files they cover
	local mods = core.get_modnames()
	local media_licenses = {}
	for i, modname in ipairs(mods) do
		local path = core.get_modpath(modname)
		local licensefile = io.open(path .. "/LICENSE", "r")
		if licensefile then
			local text = licensefile:read("a")
			local split = string.split(text, "===\nMedia Licenses\n===", false, 2)
			text = split[2] or ""
			local sections = string.split(text, "\n===", false)
			for k, section in ipairs(sections) do
				split = string.split(section, "\nFiles:\n", false)
				local license_text = split[1]
				license_text = string.gsub("$"..license_text, "$\n", "")
				local files = split[2]
				if files ~= nil then
					if not media_licenses[license_text] then media_licenses[license_text] = {} end
					table.insert(media_licenses[license_text], split[2])
				end
			end
		end
	end

	for license_text, section_list in pairs(media_licenses) do
		media_licenses[license_text] = table.concat(section_list, "\n")
		local list = {}
		for i, line in ipairs(string.split(media_licenses[license_text], "\n")) do
			if line ~= "" then
				table.insert(list, "    " .. line)
			end
		end
		media_licenses[license_text] = table.concat(list, "\n")
	end

	local txt = {}
	for license_text, section in pairs(media_licenses) do
		table.insert(txt, "")
		table.insert(txt, license_text)
		table.insert(txt, "Files:")
		table.insert(txt, section)
	end

	table.insert(txt, "")
	table.insert(txt, "")
	table.insert(txt, "")

	local elem = assert(aom_credits.form:get_element_by_id("media_license_area"))
	elem:add_child(
		aom_bform.element.textarea.new(
			{18, 10}, nil, "", table.concat(txt, "\n"), true, nil
		):set_offset({0,-0.3})
	)
end


-- add credits button, but make sure it's all the way at the end of the menu
-- hacky, yes.
core.after(0.2, function()
	if not core.get_modpath("aom_igm") then return end
	aom_igm.register_page_process("main_buttons", function(fs, player, pagename, data)
		data.y = data.y or 0
		table.insert(fs, "button[-2.2,"..data.y..";4.4,1;credits;"..S("credits").."]")
		data.y = data.y + 1
	end)

	aom_igm.register_page_action("main", function(player, pagename, fields)
		if fields.credits then
			aom_igm.do_sound_click(player, "aom_igm_click")
			aom_credits.form:show_form(player, false)
		end
	end)
end)
