local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

-- Juncus effusus

local grass_box = {
    type = "fixed",
    fixed = {
        -6/16, -8/16, -6/16,
        6/16, 16/16, 6/16,
    }
}


local np = {
    offset = 0.5,
    scale = 0.5,
    spread = {x = 2, y = 2, z = 2},
    seed = 324 + (minetest.get_mapgen_setting("seed") or 0),
    octaves = 2,
    persist = 0.1,
    lacunarity = 2.317,
}
local iperlin = PerlinNoise(np)

local function clamp(v, min, max)
    return math.min(math.max(v, min), max)
end

local variant_count = 2

local function on_generated(pos, force_variant)
    local nv
    if force_variant then
        nv = force_variant
    else
        nv = clamp(iperlin:get_3d(pos), 0, 0.99)
        nv = math.floor(nv * (variant_count+1))
    end
    minetest.swap_node(pos, {
        name = 'aom_flora:' .. "rush_grass_" .. nv,
        param2 = math.random(0, 239)
    })
end

for i = 0, variant_count do
    minetest.register_node('aom_flora:rush_grass_' .. i, {
        -- TL: tall swamp grass
        description = S("Rush Grass"),
        mesh = "2node_3poly_foliage.b3d",
        use_texture_alpha = "clip",
        drawtype = "mesh",
        walkable = false,
        waving = 1, --1
        paramtype = "light",
        paramtype2 = "degrotate",
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = grass_box,
        groups = {nature = 1, attached_node = 1, flamamble = 1, item_grass = 1,
            player_place_only = 1, dig_immediate = 3, flora = 1, decoration = 1, },
        drop = "aom_flora:rush_grass_0",
        tiles = {"aom_rush_grass_" .. i .. ".png"},
        buildable_to = true,
        sounds = aom_sounds.default_plant(),
        on_place = function(itemstack, placer, pointed_thing)
            return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        end,
        after_generated = function(pos)
            on_generated(pos, (i==0) and 0)
        end,
        on_construct = (i>=0) and function(pos)
            local nv = clamp(iperlin:get_3d(pos), 0, 0.99)
            nv = math.floor(nv * (variant_count+1))
            minetest.swap_node(pos, {
                name = 'aom_flora:' .. "rush_grass_" .. nv,
                param2 = math.random(0, 239)
            })
        end or nil,
    })
end

-- aom_flora:rush_grass_0