local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local anvil_size = {
    type = "fixed",
    fixed = {-4/16, -8/16, -4/16, 4/16, -2/16, 4/16},
}

minetest.register_node("aom_cooking:anvil", {
    description = S("Iron Anvil"),
    _tt_color = 2,
    _tt_long_desc = S("Can flatten bars into sheets."),
    _tt_how_to_use = S("[place] with an ingot in hand to press into sheets") .. "\n" ..
        S("[dig] to take items"),
    groups = { item_anvil = 1, solid = 1, furniture = 1, oddly_breakable_by_hand = 2,
        iron = 1, cooker = 1, cooker_anvil = 1, cracky = 1, },
    drawtype = "mesh",
    use_texture_alpha = "opaque",
    paramtype = "light",
    paramtype2 = "facedir",
    tiles = {"aom_anvil.png"},
    mesh = "aom_anvil.b3d",
    sounds = (aom_sounds and aom_sounds.default_metal()) or {},
    collision_box = anvil_size,
    selection_box = anvil_size,
    _on_node_update = function(pos, cause, user, count)
        local timer = minetest.get_node_timer(pos)
        if not timer:is_started() then
            timer:start(1.0)
        end
    end,
    _on_cook = function(pos, node)
        minetest.sound_play("aom_anvil_craft", {
            gain = 0.05,
            pos = pos,
            max_hear_distance = 5,
        })
        for x=0, 10 do
            minetest.add_particle({
                pos = vector.offset(pos, 0, 0.1, 0),
                velocity = vector.new((math.random()-0.5)*3, (math.random())*2, (math.random()-0.5)*3),
                expirationtime = math.random() * 1,
                size = math.random() * 4,
                collisiondetection = false,
                vertical = false,
                texture = "aom_cooking_particle_sparks.png",
                glow = 14,
            })
        end
    end,
    _cook_group = function(pos)
        return "anvil"
    end,
    on_timer = aom_cooking.cooker_node_timer,
    on_construct = aom_cooking.cooker_on_construct,
    on_punch = function(pos, node, clicker, itemstack, pointed_thing)
        aom_cooking.cooker_take_item(pos, node, clicker, itemstack, pointed_thing)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        return aom_cooking.cooker_give_item(pos, node, clicker, itemstack, pointed_thing)
    end,
    on_place = function(itemstack, placer, pointed_thing)
        return minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
    end,
    _on_input_item = function(pos, itemstack)
        return aom_cooking.cooker_offer_item(pos, itemstack)
    end,
    _on_take_item = function(pos, itemstack, to_pos)
        aom_cooking.update_infotext(pos)
    end,
})




-- temporary crafting recipe
if true then
    local s = "aom_items:iron_bar"
    minetest.register_craft({
        output = "aom_cooking:anvil",
        recipe = {
            {s,  s, s},
            {"", s, ""},
            {s,  s, s},
        },
    })
end


