local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_mirecaves.max
local alt_min = aom_mirecaves.min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'mirecaves'

aom_biomes.register_biome({
    name = this_biome,

    node_top = "aom_mirecaves:stone_moss",
    depth_top = 1,

    node_filler = 'aom_mirecaves:stone',
    depth_filler = 2,

    node_riverbed = 'aom_mirecaves:stone',
    depth_riverbed = 3,

    node_stone = "aom_mirecaves:stone",

    y_max = alt_max,
    y_min = alt_min,
    -- y_min_ocean = sealevel - 80,

    heat_point = 99,
    humidity_point = 91,
    vertical_blend = 10,
}, {"mirecaves", "caves"})



if minetest.get_modpath("aom_weather") then
    aom_weather.allow_biome_weathers(this_biome, {
        "light_rain",
        "heavy_rain",
    }, false)
    -- minetest.log("adding weathers")
end

--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


local w = aom_mirecaves.worknodes

local size = 1

local np = {
    offset = sealevel+10,
    scale = 200,
    spread = {x = size, y = size, z = size},
    seed = 5643,
    octaves = 2,
}
local npt = {
    offset = 40,
    scale = 110,
    spread = {x = 60, y = 60, z = 60},
    seed = 900786,
    octaves = 4,
    persistence = 0.2
}

if (aom_mirecaves.mg_name ~= "flat") and (aom_mirecaves.mg_name ~= "singlenode") then
    dofile(mod_path .. "/mapgen" .. "/biome_terrain.lua")
end

--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

-- use worknode, since if we put this in biome def it would not get fixed with ores here
minetest.register_ore({
    ore_type       = "stratum",
    ore            = w.topsoil2,
    wherein        = {"aom_mirecaves:stone_moss"},
    y_min = alt_min-50,
    y_max = alt_max+50,
    biomes = aom_mirecaves.biome_list,
})

------------------- make soil more interesting
size = 4
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_mirecaves:stone_moss",
    wherein		= {w.topsoil2},
    y_min = alt_min,
    y_max = alt_max + 100,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel-100,
        scale = 400,
        spread = {x = size, y = size, z = size},
        seed = 7565,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 440,
        scale = 800,
        spread = {x = 4, y = 4, z = 4},
        seed = 4690,
        octaves = 2,
        persistence = 0.01
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})


--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


-- GRASS
size = 30
np = {
    offset = sealevel + 30,
    scale = 30,
    spread = {x = size, y = size, z = size},
    seed = 96824,
    octaves = 2,
}
npt = {
    offset = 10,
    scale = 0,
    spread = {x = 40, y = 40, z = 40},
    seed = 8756452,
    octaves = 2,
    persistence = 0.01
}
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_stone:stone",
    wherein		= {"aom_mirecaves:stone"},
    y_min = sealevel - 80,
    y_max = alt_max + 100,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_soil:grass",
    wherein		= {w.topsoil2, "aom_mirecaves:stone_moss"},
    y_min = sealevel - 80,
    y_max = alt_max + 100,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})


-- GRASS VARIANT
size = 40
np = {
    offset = sealevel + 30,
    scale = 30,
    lucanarity = 1.77,
    spread = {x = size, y = size, z = size},
    seed = 96824,
    octaves = 4,
}
npt = {
    offset = 10,
    scale = 0,
    spread = {x = 40, y = 40, z = 40},
    seed = 8756452,
    octaves = 2,
    persistence = 0.01
}
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_stone:stone",
    wherein		= {"aom_mirecaves:stone"},
    y_min = sealevel - 80,
    y_max = alt_max + 100,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_soil:grass_variant_4",
    wherein		= {w.topsoil2, "aom_mirecaves:stone_moss"},
    y_min = sealevel - 80,
    y_max = alt_max + 100,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})


------------------
minetest.register_ore({
    ore_type	= "scatter",
    ore		    = "aom_soil:grass_variant_2",
    wherein		= {"aom_soil:grass"},
    clust_scarcity	= 100,
    clust_num_ores	= 2,
    clust_size	= 4,
    y_max = alt_max,
    y_min = alt_min,
    biomes = {this_biome},
})

minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_soil:grass_variant_1",
    wherein		= {"aom_soil:grass"},
    clust_scarcity	= 200,
    clust_num_ores	= 6,
    clust_size	= 5,
    noise_params = {
        offset = 0.35,
        scale = 0.8,
        spread = {x = 20, y = 20, z = 20},
        seed = 64758,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 1.76,
    },
    y_max = alt_max,
    y_min = alt_min,
    biomes = {this_biome},
})




--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||



dofile(mod_path .. "/mapgen" .. "/lights.lua")



--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path
-- GIANT oaks
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -1
})
-- GIANT oaks
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -1
})
-- GIANT oaks
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -2
})


minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.008,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.008,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.008,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
})



aom_biomes.add_grass(0, 6546, {this_biome})
aom_biomes.add_grass(1, 6546, {this_biome})
aom_biomes.add_grass(2, 6546, {this_biome})
aom_biomes.add_grass(3, 6546, {this_biome})





