local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local nolmer = {
    light = 5,
}


minetest.register_node("aom_mirecaves:nolmer", {
    description = S("Nolmer"),
    _tt_color = 2,
    groups = { full_solid = 1, nature = 1, item_nolmer = 1, mirecaves = 1, nolmer = 1, oddly_breakable_by_hand = 1, solid = 1, suffocates = 2 },
    tiles = {"aom_mirecaves_nolmer.png"},
    drawtype = "normal",
    -- use_texture_alpha = "blend", -- causes issues with water
    paramtype = 'light',
    sounds = aom_sounds.default_soil(),
    light_source = nolmer.light + 1,
})
aom_util.register_all_shapes("aom_mirecaves:nolmer")


minetest.register_node("aom_mirecaves:nolmer_stem", {
    -- TL: treetrunk like, mushroom node
    description = S("Nolmer Stem"),
    _tt_color = 2,
    groups = { full_solid = 1, nature = 1, item_nolmer_stem = 1, mirecaves = 1, nolmer = 1, oddly_breakable_by_hand = 1, solid = 1, suffocates = 2 },
    tiles = {
        "aom_mirecaves_nolmer_stem_top.png",
        "aom_mirecaves_nolmer_stem_top.png",
        "aom_mirecaves_nolmer_stem.png",
    },
    drawtype = "normal",
    paramtype = 'light',
    paramtype2 = "facedir",
    drop = {
        max_items = 2,
        items = {
            {
                -- rarity = 1,
                items = {"aom_mirecaves:nolmer_stem"},
            },
        },
    },
    sounds = aom_sounds.default_soil(),
    light_source = nolmer.light,
    on_place = function(itemstack, placer, pointed_thing)
        return minetest.rotate_and_place(itemstack, placer, pointed_thing)
    end,
})
-- aom_util.register_all_shapes("aom_mirecaves:nolmer_stem")


local nolmera_box = {
    type = "fixed",
    fixed = {
      -5/16, -8/16, -5/16,
       5/16, -6/16,  5/16,
    }
}

local c = 2
for i=1, c do
    minetest.register_node("aom_mirecaves:nolmera_"..i, {
        -- TL: mushroom-like plant
        description = S("Nolmera"),
        _tt_color = 2,
        drawtype = "plantlike",
        waving = 1,
        paramtype = "light",
        paramtype2 = "meshoptions",
        param2 = 8 + 4 + 32,
        -- inventory_image = "aom_mirecaves_nolmera.png",
        -- wield_image = "aom_mirecaves_nolmera.png",
        walkable = false,
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = nolmera_box,
        groups = { nature = 1, attached_node = 1, item_nolmer = 1, nolmer = 1, dig_immediate = 3, flora = 1, },
        drop = "aom_mirecaves:nolmera_1",
        tiles = {"aom_mirecaves_nolmera_"..i..".png"},
        sounds = aom_sounds.default_plant(),
        -- on_place = function(itemstack, placer, pointed_thing)
        --     return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        -- end,
        on_construct = function(pos)
            local node = minetest.get_node(pos)
            node.name = "aom_mirecaves:nolmera_" .. math.random(1,c)
            node.param2 = 8 + 2 + 32
            minetest.swap_node(pos, node, true)
        end,
        light_source = nolmer.light + 0
    })
end


nolmera_box = {
    type = "fixed",
    fixed = {
      -5/16, -8/16, -5/16,
       5/16,  8/16,  5/16,
    }
}
c = 1
for i=1, c do
    minetest.register_node("aom_mirecaves:nolmera_vine_"..i, {
        -- TL: glowing vine
        description = S("Nolmera Vine"),
        _tt_color = 2,
        drawtype = "plantlike",
        -- waving = 1,
        paramtype = "light",
        paramtype2 = "meshoptions",
        -- param2 = 8 + 4 + 32,
        -- inventory_image = "aom_mirecaves_nolmera.png",
        -- wield_image = "aom_mirecaves_nolmera.png",
        walkable = false,
        is_ground_content = false,
        sunlight_propagates = true,
        selection_box = nolmera_box,
        groups = { nature = 1, item_nolmer = 1, nolmer = 1, dig_immediate = 3, flora = 1, vine = 1, },
        drop = "aom_mirecaves:nolmera_vine_1",
        tiles = {"aom_mirecaves_nolmera_vine_"..i..".png"},
        use_texture_alpha = "blend",
        sounds = aom_sounds.default_plant(),
        -- on_place = function(itemstack, placer, pointed_thing)
        --     return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        -- end,
        on_construct = function(pos)
            local node = minetest.get_node(pos)
            node.name = "aom_mirecaves:nolmera_vine_" .. math.random(1,c)
            -- node.param2 = 8 + 2 + 32
            minetest.swap_node(pos, node, true)
        end,
        light_source = 10,
        _on_node_update = function(pos, cause, user, count, payload, last_pos)
            if cause == "dig" or cause == "place" then
                local node = minetest.get_node_or_nil(vector.offset(pos, 0, 1, 0))
                if not node then return end
                if (minetest.get_item_group(node.name, "solid") == 0) and (minetest.get_item_group(node.name, "vine") == 0) then
                    minetest.dig_node(pos)
                end
            end
            return
        end,
    })
end



local cave_water_color = "#9f6fd5".."80"

minetest.register_node('aom_mirecaves:river_cave_water_source', {
    description = S('River Water Source'),
    groups = {
        nature = 1, water_source = 1, liquid = 1, water = 1,
        cave_water = 1, flowing = 0, unobtainable = 1,
    },

    tiles = { {
        name = "aom_mirecaves_nolmer.png^[colorize:"..cave_water_color..":255",
        backface_culling = false,
    } },
    use_texture_alpha = 'blend',
    drawtype = 'liquid',
    paramtype = 'light',

    walkable = false,
    liquid_move_physics = true,
    move_resistance = 1,
    drowning = 0,
    pointable = false,
    diggable = false,
    buildable_to = true,
    liquidtype = "source",
    liquid_viscosity = 0,
    liquid_renewable = false,
    liquid_range = 4,
    liquid_alternative_source = "aom_mirecaves:river_cave_water_source",
    liquid_alternative_flowing = "aom_mirecaves:river_cave_water_flowing",
    -- light_source = 3,
    post_effect_color = {a=150, r=0x43, g=0x3C, b=0x6C},
})

minetest.register_node('aom_mirecaves:river_cave_water_flowing', {
    description = S('Flowing River Water'),
    groups = {
        nature = 1, water_flowing = 1, liquid = 1, water = 1,
        cave_water = 1, flowing = 1, unobtainable = 1,
    },

    special_tiles = {
      {
        name = "aom_mirecaves_nolmer.png^[colorize:"..cave_water_color..":255",
        backface_culling = false,
      },
      {
        name = "aom_mirecaves_nolmer.png^[colorize:"..cave_water_color..":255",
        backface_culling = false,
      }
    },
    tiles = {"aom_mirecaves_nolmer.png^[colorize:"..cave_water_color..":255"},
    use_texture_alpha = 'blend',
    drawtype = "flowingliquid",

    paramtype = 'light',
    paramtype2 = "flowingliquid",

    walkable = false,
    liquid_move_physics = true,
    move_resistance = 1,
    drowning = 0,
    pointable = false,
    diggable = false,
    buildable_to = true,
    liquidtype = "flowing",
    liquid_viscosity = 0,
    liquid_range = 4,
    liquid_renewable = false,
    liquid_alternative_source = "aom_mirecaves:river_cave_water_source",
    liquid_alternative_flowing = "aom_mirecaves:river_cave_water_flowing",
    -- light_source = 3,
    post_effect_color = {a=150, r=0x43, g=0x3C, b=0x6C},
})



nolmera_box = {
    type = "fixed",
    fixed = {
      -5/16, -7.9/16, -5/16,
       5/16, -7/16,  5/16,
    }
}
local nolmera_colbox = {
    type = "fixed",
    fixed = {
      -5/16, -8/16, -5/16,
       5/16, -7/16,  5/16,
    }
}

c = 1
for i=1, c do
    minetest.register_node("aom_mirecaves:cave_lily_"..i, {
        -- TL: lilypad-like
        description = S("Cave Lily"),
        _tt_color = 2,
        drawtype = "nodebox",
        paramtype = "light",
        -- param2 = 8 + 4 + 32,
        -- inventory_image = "aom_mirecaves_nolmera.png",
        -- wield_image = "aom_mirecaves_nolmera.png",
        collision_box = nolmera_colbox,
        selection_box = nolmera_colbox,
        node_box = nolmera_box,
        walkable = true,
        is_ground_content = true,
        sunlight_propagates = true,
        groups = { nature = 1, item_nolmer = 1, nolmer = 1, dig_immediate = 3, flora = 1, },
        drop = "aom_mirecaves:cave_lily_1",
        tiles = {"aom_mirecaves_cave_lily_"..i..".png"},
        use_texture_alpha = "blend",
        sounds = aom_sounds.default_plant(),
        liquids_pointable = true,
        on_place = function(itemstack, placer, pointed_thing)
            return aom_util.only_place_above(itemstack, placer, pointed_thing, {"cave_water"})
        end,
        on_construct = function(pos)
            local node = minetest.get_node(pos)
            node.name = "aom_mirecaves:cave_lily_" .. math.random(1,c)
            minetest.swap_node(pos, node, true)
        end,
        light_source = 6,
        _on_node_update = function(pos, cause, user, count, payload, last_pos)
            if cause == "dig" or cause == "place" then
                local below = minetest.get_node(vector.offset(pos, 0, -1, 0))
                if minetest.get_item_group(below.name, "cave_water") == 0 then
                    minetest.dig_node(pos)
                end
            end
        end,
    })
end
