local S = core.get_translator(core.get_current_modname())

minetest.register_craftitem("aom_itemframe:frame", {
    description = S("Item Frame"),
    _tt_color = 1,
    _tt_long_desc = S("Holds a visual representation of an item and the item itself."),
    _tt_how_to_use = S("[place] to add item").."\n"..S("[punch] to take item"),
    inventory_image = "aom_itemframe_inventory.png",
    wield_image = "aom_itemframe_inventory.png",
    -- wield_scale = {x=1, y=1, z=1},
    groups = { furniture = 1, disallow_itemframe = 1, },
    on_place = function(itemstack, player, pointed_thing)
        local ret = aom_util.try_rightclick(itemstack, player, pointed_thing, false)
        if ret then
            return ret
        end
        return aom_itemframe.new_itemframe(itemstack, player, pointed_thing)
    end,
})

if minetest.get_modpath("aom_tcraft") then
    aom_tcraft.register_craft({
        output = "aom_itemframe:frame",
        items = {
            ["aom_items:stick"] = 4,
            ["aom_items:plant_fibre"] = 4,
            ["aom_items:iron_sheet"] = 1,
        },
    })
end
