local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)


minetest.register_node('gm_windmills:windmill', {
    description = S("Windmill"),
    groups = { solid = 1, full_solid = 1, not_in_creative_inventory = 1 },
    drawtype = "mesh",
    drop = "",
    use_texture_alpha = "clip",
    paramtype = "light",
    -- paramtype2 = "facedir",
    tiles = {"gm_windmills_windmill.png"},
    mesh = "gm_windmills_windmill.obj",
    sounds = (aom_sounds and aom_sounds.default_stone()) or {},
    on_construct = function(pos)
        local obj = minetest.add_entity(pos, "gm_windmills:windmill_head_ENTITY")
        -- local ent = obj:get_luaentity()
    end,
    _aom_on_explode = function(pos)
        gm_windmills.on_windmill_destroyed(pos)
    end,
})


local csize = 0.3
minetest.register_entity("gm_windmills:windmill_head_ENTITY", {
    initial_properties = {
        visual = "mesh",
        mesh = "gm_windmills_windmill_head.b3d",
        backface_culling = false,
        textures = {
            "gm_windmills_windmill_blades.png",
            "gm_windmills_windmill.png",
        },
        stepheight = 0,
        hp_max = 1,
        physical = false,
        collisionbox = {
            -csize, -csize/4, -csize, csize, csize/4, csize,
        },
        static_save = false,
    },
    _name = "gm_windmills:windmill_head_ENTITY",
    on_step = function(self, dtime)
        local node = minetest.get_node(self.object:get_pos())
        if node.name ~= "gm_windmills:windmill" then
            self.object:remove()
            return
        end
        if not self._init then
            self._init = true
            self.object:set_animation({x=0,y=79}, 24, 0.3, true)
        end
    end,
    -- on_punch = function(self)
    --     self.object:remove()
    -- end,
    on_activate = function(self, staticdata, dtime_s)
        local data = minetest.deserialize(staticdata)
        if data then
            for key, val in pairs(data) do
                self[key] = val
            end
            if data._rotation then
                self.object:set_rotation(data._rotation)
            end
        end
        self.object:set_armor_groups({
            fleshy = 0
        })
    end,
    get_staticdata = function(self)
        local data = {}
        for i, key in pairs(self._aom_staticdata_load_list) do
            if key and self[key] ~= nil then
                data[key] = self[key]
            end
        end
        return minetest.serialize(data)
    end,
    _aom_staticdata_load_list = {
        "_rotation",
    },
})

