local S = core.get_translator(core.get_current_modname())

if aom_playerapi.has_aom_settings then
    aom_settings.register_setting("gameplay_fov", 1, S("Player FOV multiplier"))
    aom_settings.register_on_change_setting("gameplay_fov", function(player, settingname, new_value, old_value)
        aom_util.set_fov(player, {
            tag = "player_fov_setting",
            fov = new_value,
            is_multiplier = true,
            transition_time = 0.2
        })
    end)
    core.register_on_joinplayer(function(player, last_login)
        core.after(0.1, function()
            local fov = aom_settings.get_setting(player, "gameplay_fov", 1)
            aom_util.set_fov(player, {
                tag = "player_fov_setting",
                fov = fov,
                transition_time = 0.2
            })
        end)
    end)
end
