local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)


local flax_box = {
	type = "fixed",
	fixed = {
		-6/16, -8/16, -6/16,
		6/16, -6/16, 6/16,
	}
}

local flax_variants = {}

local function random_grow_time()
	return (math.random() * 100 + 400)
end

local crop_fail_chance = 0.1

local function grow_flax(pos, node, active_object_count, active_object_count_wider)
	aom_util.did_abm("crop")
	local light = minetest.get_node_light(pos, 0.5)
	if light > 8 then
		local def = minetest.registered_nodes[node.name]
		local next_stage = (def and def._growth_stage + 1) or 1
		-- random chance to leave as immature plant
		if next_stage >= 3 and (math.random() < crop_fail_chance) then return false end
		node.name = "aom_flora:flax_" .. next_stage
		if not minetest.registered_nodes[node.name] then return false end

		minetest.set_node(pos, node)
		return true
	end
end

local drops = {
	full = {
		max_items = 4,
		items = {
			{
				items = {'aom_flora:flax_bundle 1'},
			},
			{
				items = {'aom_flora:flax_seeds 1'},
			},
			{
				items = {'aom_flora:flax_seeds 1'},
				rarity = 3
			},
		},
	},
	partial = {
		max_items = 1,
		items = {
			{
				items = {'aom_flora:flax_seeds'},
				rarity = 2
			},
		},
	},
}


minetest.register_craftitem("aom_flora:flax_bundle", {
	description = S("Flax Bundle"),
	_tt_long_desc = S("Can be made into fibre."),
	inventory_image = "aom_flax_bundle.png",
	groups = { item_flax_bundle = 1, item_burns = 1, craftitem = 1, flax = 1, produce = 1, },
})

minetest.register_craft({
	output = "aom_items:plant_fibre 2",
	type = "shapeless",
	recipe = {"aom_flora:flax_bundle"},
})


minetest.register_node("aom_flora:flax_seeds", {
	description = S("Flax Seed"),
	_tt_long_desc = S("Can be planted.") .. "\n" .. S("Needs sunlight to grow."),
	inventory_image = "aom_flax_seeds.png",
	wield_image = "aom_flax_seeds.png",
	drawtype = "airlike",
	walkable = false,
	paramtype = "light",
	selection_box = {
	type = "fixed",
	fixed = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},},
	is_ground_content = true,
	sunlight_propagates = true,
	groups = { item_flax_seeds = 1, item_burns = 1, player_place_only = 1, decoration = 1, },
	after_place_node = function(pos, placer, itemstack, pointed_thing)
		minetest.set_node(pos, {name=flax_variants[1], param2 = 8})
		local timer = minetest.get_node_timer(pos)
		timer:start(random_grow_time())
	end,
	on_place = function(itemstack, placer, pointed_thing)
		return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
	end,
})

for i=0, 4 do
	local drop = (i == 4 and drops["full"]) or drops["partial"]
	local tiles = {"aom_flax_" .. i .. ".png"}
	local growing = ((i ~= 4) and i + 1) or 0
	flax_variants[#flax_variants+1] = 'aom_flora:flax_' .. i
	minetest.register_node('aom_flora:flax_' .. i, {
		description = S("Flax Plant"),
		drawtype = "plantlike",
		walkable = false,
		waving = 1,
		paramtype = "light",
		paramtype2 = "meshoptions",
		inventory_image = "aom_flax_" .. i .. ".png",
		wield_image = "aom_flax_" .. i .. ".png",
		is_ground_content = true,
		sunlight_propagates = true,
		selection_box = flax_box,
		groups = { nature = 1, attached_node = 1, not_in_creative_inventory = 1, item_burns = 1, item_flax_plant = 1,
			dig_immediate = 3, flora = 1, growth_stage = i, flax_growing = growing },
		_growth_stage = i,
		drop = drop,
		tiles = tiles,
		buildable_to = false,
		sounds = aom_sounds.default_plant(),
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local variant = flax_variants[math.random(1, #flax_variants)]
			minetest.swap_node(pos, {name=variant, param2 = 8})
		end,
		on_timer = function(pos, elapsed)
			if grow_flax(pos, minetest.get_node(pos)) then
				local timer = minetest.get_node_timer(pos)
				timer:start(random_grow_time())
			end
		end,
		_on_node_update = function(pos, cause, user, data)
			local timer = minetest.get_node_timer(pos)
			if timer:is_started() then
				return false
			else
				timer:start(random_grow_time())
			end
		end,
	})
end
