

aom_spawn_inhibitors.registered_inhibitor_entities = {}
aom_spawn_inhibitors.max_distance = 1
local reg = aom_spawn_inhibitors.registered_inhibitor_entities
function aom_spawn_inhibitors.register_inhibitor_entity(entity_name, dist)
    reg[entity_name] = dist

    if aom_spawn_inhibitors.max_distance < dist then
        aom_spawn_inhibitors.max_distance = dist
    end
end

function aom_spawn_inhibitors.squaredist(p1, p2)
    return (((p1.x - p2.x) ^ 2) + ((p1.y - p2.y) ^ 2) + ((p1.z - p2.z) ^ 2))
end
local squaredist = aom_spawn_inhibitors.squaredist

function aom_spawn_inhibitors.is_uninhibited(pos)
    local d = aom_spawn_inhibitors.max_distance + 4 -- extra
    local objects = minetest.get_objects_in_area(
        vector.offset(pos, -d, -d, -d),
        vector.offset(pos,  d,  d,  d)
    )
    for i, object in ipairs(objects) do
        local ent = object:get_luaentity()
        if not (ent and reg[ent.name]) then goto continue end

        if (ent._is_position_uninhibited == nil) then
            if squaredist(object:get_pos(), pos) < reg[ent.name] ^ 2 then
                return false
            end
        elseif not ent._is_position_uninhibited(ent, pos) then
            return false
        end
        ::continue::
    end
    return true
end

if minetest.get_modpath("aom_mob_spawn") then
    aom_mob_spawn.register_spawnrule(aom_spawn_inhibitors.is_uninhibited)
else
    minetest.log("error", "aom_spawn_inhibitors will be ineffective: could not find `aom_mob_spawn` mod. ")
end
