local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

-- BUTTON
aom_wire.register_button("aom_machines:button", {
	description = S("Button"),
	_tt_long_desc = S("Activates other nodes connected by wire."),
	_tt_how_to_use = S("[place] to activate"),
	_tt_color = 2,
	groups = { oddly_breakable_by_hand = 3, cracky = 1, attached_node = 1, mechanisms = 1, },
	tiles = {
		"aom_stone_granite_brick_long_end_right.png",
	},
	sounds = minetest.get_modpath("aom_sounds") and aom_sounds.default_stone() or nil,
	_aom_wire_activation_sound = {
		press = {
			name = "aom_wrench_plip",
			gain = 0.1, pitch = 1.2
		},
	},
	walkable = false,
})

if aom_machines.has_aom_tcraft then
	aom_tcraft.register_craft({
		output = "aom_machines:button",
		items = {
			["aom_stone:stone_brick"] = 1,
			["aom_items:iron_bar"] = 1,
		},
	})
end
