local S = core.get_translator(core.get_current_modname())

if (minetest.get_modpath("aom_settings") == nil) then return end

if minetest.get_modpath("age_of_mending") ~= nil then
    -- player
    -- TL: setting description for all following
    aom_settings.register_setting("item_auto_pickup", true, S("Enable auto pickup"))
    aom_settings.register_setting("item_pickup_key", "sneak", S("Pickup items key"))
    aom_settings.register_setting("item_auto_pickup_delay", 3, S("Pickup delay"))
    aom_settings.register_setting("item_auto_pickup_max_dist", 2.5, S("Pickup max distance"))
    -- server
    aom_settings.register_setting("item_punchable", true, S("Items can be punched to pickup"), "server")
    aom_settings.register_setting("item_scale", 0.3, S("Item scale"), "server")
    aom_settings.register_setting("item_float_in_water", true, S("Items float in water"), "server")
    aom_settings.register_setting("item_float_only_if_set", true, S("Items float only if group set"), "server")
    aom_settings.register_setting("item_water_push_vel", 4, S("Items push vel in water"), "server")
    aom_settings.register_setting("item_sound", 0.2, S("Item move sounds"), "server")
    aom_settings.register_setting("item_merge_dist", 0.6, S("Item merge distance"), "server")
    aom_settings.register_setting("item_pickup_max_dist", 2.5, S("Pickup max distance"), "server")
    aom_settings.register_setting("item_lay_flat", true, S("Items lay flat"), "server")
    aom_settings.register_setting("item_float_height", 0.3, S("Item float height on ground"), "server")
    aom_settings.register_setting("item_burn_in_fire", true, S("Items can burn in fire"), "server")
    aom_settings.register_setting("item_burn_only_flammable", true, S("Items only burn if marked flammable"), "server")
    aom_settings.register_setting("item_rotation", 2, S("Items rotate radians per second"), "server")
    aom_settings.register_setting("item_initial_rotation", true, S("Items have random initial rotation"), "server")
else -- if it's not Age of Mending, and is being used as a general api
    -- player
    aom_settings.register_setting("item_auto_pickup", true, S("Enable auto pickup"))
    aom_settings.register_setting("item_pickup_key", "null", S("Pickup items key"))
    aom_settings.register_setting("item_auto_pickup_delay", 3, S("Pickup delay"))
    aom_settings.register_setting("item_auto_pickup_max_dist", 2.0, S("Pickup max distance"))
    -- server
    aom_settings.register_setting("item_punchable", true, S("Items can be punched to pickup"), "server")
    aom_settings.register_setting("item_scale", 0.3, S("Item scale"), "server")
    aom_settings.register_setting("item_float_in_water", true, S("Items float in water"), "server")
    aom_settings.register_setting("item_float_only_if_set", false, S("Items float only if group set"), "server")
    aom_settings.register_setting("item_water_push_vel", 4, S("Items push vel in water"), "server")
    aom_settings.register_setting("item_sound", 0.2, S("Item move sounds"), "server")
    aom_settings.register_setting("item_merge_dist", 0.6, S("Item merge distance"), "server")
    aom_settings.register_setting("item_lay_flat", false, S("Items lay flat"), "server")
    aom_settings.register_setting("item_float_height", 0.3, S("Item float height on ground"), "server")
    aom_settings.register_setting("item_burn_in_fire", false, S("Items can burn in fire"), "server")
    aom_settings.register_setting("item_burn_only_flammable", false, S("Items only burn if marked flammable"), "server")
    aom_settings.register_setting("item_rotation", 2, S("Items rotate radians per second"), "server")
    -- TL: setting descriptions end
    aom_settings.register_setting("item_initial_rotation", true, S("Items have random initial rotation"), "server")
end
