local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

local node_box
if true then
	local pw = 6/16
	local pl = 8/16
	local pa = 4/16
	node_box = {
		type = "fixed",
		fixed = {
			{-pl, -pl,  pa,
			  pl,  pl,  pl},
			{-pw, -pw, -pa,
			  pw,  pw,  pa},
			{-pa, -pa, -pl,
			  pa,  pa, -pa},
		},
	}
end

local function get_formspec(meta)
	local fs, size = aom_inventory.player.get_formspec(nil)
	local y = 12-size.y-2
	local always_active = (meta and ((meta:get_string("always_active") ~= "")))
	local btn_col = (always_active and "#1a3") or "#a13"
	return table.concat({
		fs,
		"container[", 12-6/2, ",", y-3.5, "]",
		aom_inventory.get_9patch(0, 0, 6, 4, aom_inventory.get_bg9patch_texture("#596498"), "false", "32"),
		((aom_inventory.get_itemslot_array(2.5, 0.5, 1, 1)) or ""),
		"list[context;main;2.5,0.5;1,1;]",

		"style_type[image_button;bgimg=aom_inv_btn.png\\^\\[multiply:", btn_col, ";bgimg_middle=8;",
		"bgimg_hovered=aom_inv_btn.png\\^\\[multiply:", btn_col, ";bgimg_pressed=aom_inv_btn_press.png\\^\\[multiply:", btn_col, ";",
		"bgcolor_hovered=#eee;bgcolor_pressed=#fff;border=false]",
		"image_button[0.5,", tostring(2.5), ";1,1;aom_wire_gui_repeat.png",
		((always_active and "^[multiply:#4f7") or "^[multiply:#f57") or "",
		";toggle_always_active; ]",
		-- TL: active ("on" or "off")
		"label[1.5,3;", core.colorize("#ccc", S("Always Active: @1",
		-- TL: active / inactive ("Always Active: @1"), 
		always_active and S("on") or S("off"))), "]",
		"container_end[]",

		"listring[context;main]",
		"listring[current_player;main]",
	})
end

local function fix_formspec(pos)
	-- set up the formspec and stuff
	local meta = core.get_meta(pos)
	local formspec = get_formspec(meta)
	if meta:get_string("formspec") == formspec then return end
	local inv = meta:get_inventory()
	inv:set_size("main", 1)
	meta:set_string("formspec", formspec)
	meta:set_string("infotext", "Siphon");
	return true
end

local function do_place_sound(pos, ndef)
	local sound = ndef.sounds and ndef.sounds.place
	if not sound then
		sound = aom_sounds.default_stone().place
	end
	sound = table.copy(sound)
	sound.pos = pos
	sound.max_hear_distance = 8
	core.sound_play(sound.name, sound)
end

local function try_place(pos, placer)
	local meta = core.get_meta(pos)
	local inv = meta:get_inventory()
	local stack = inv:get_stack("main", 1)
	if not (stack and stack:get_count() > 0) then return false end
	if not core.registered_nodes[stack:get_name()] then return false end
	local dir = core.facedir_to_dir(core.get_node(pos).param2)
	local to_pos = vector.add(pos, dir)
	local node = core.get_node_or_nil(to_pos)
	if not node then return false end
	if node.name == stack:get_name() then return false end
	local ndef = core.registered_nodes[node.name]
	if (not ndef) or (not ndef.buildable_to) then return false end
	local pointed_thing = {
		above = pos,
		under = to_pos,
		type = "node",
	}
	local p
	local idef = stack:get_definition()
	stack, p = aom_util.item_place_node(stack, placer, pointed_thing, nil)
	if stack then
		inv:set_stack("main", 1, stack)
	end
	if not p then return false end
	do_place_sound(pos, idef)
	return true
end

core.register_node("aom_machines:node_placer", {
	description = S("Node Placer"),
	_tt_color = 3,
	_tt_long_desc = S("On wire signal, places nodes from inventory."),
	groups = { cracky = 1, oddly_breakable_by_hand = 2, solid = 1, mechanisms = 1, storage = 1, },
	tiles = {
		"aom_machines_placer.png^[transformR90",
		"aom_machines_placer.png^[transformR270",
		"aom_machines_placer.png",
		"aom_machines_placer.png^[transformFX",
		"aom_machines_placer_front.png",
		"aom_machines_placer_back.png",
	},
	sounds = aom_sounds.default_wood(),
	paramtype = "light",
	sunlight_propagates = true,
	paramtype2 = "facedir",
	drawtype = "nodebox",
	node_box = node_box,
	on_place = aom_util.rotate_and_place_against,
	on_construct = function(pos)
		fix_formspec(pos)
	end,
	on_destruct = function(pos)
		aom_inventory.drop_contents(pos)
		local nt = core.get_node_timer(pos)
		if nt:is_started() then nt:stop() end
	end,
	on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
		fix_formspec(pos)
	end,
	on_timer = function(pos, elapsed)
		core.get_node_timer(pos):stop()
		local meta = core.get_meta(pos)
		try_place(pos)
		if meta:get_string("always_active") ~= "" then
			return true
		end
	end,
	on_receive_fields = function(pos, formname, fields, sender)
		if fields["toggle_always_active"] then
			local meta = core.get_meta(pos)
			local nt = core.get_node_timer(pos)
			if meta:get_string("always_active") ~= "" then
				meta:set_string("always_active", "")
			else
				meta:set_string("always_active", "1")
				if not nt:is_started() then
					nt:start(1)
					nt:set(1, 0.9)
				end
			end
			fix_formspec(pos)
		end
	end,
	_on_wire_input = function(pos, user, source)
		local node = core.get_node_or_nil(pos)
		if not node then return end
		local nt = core.get_node_timer(pos)
		if nt:is_started() then return end
		nt:start(1)
		nt:set(1, 0.9)
	end,
	_has_formspec = true,
})

aom_tcraft.register_craft({
	output = "aom_machines:node_placer",
	items = {
		["aom_stone:cobble"] = 10,
		["aom_items:bronze_sheet"] = 2,
	},
})
