
local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(minetest.get_current_modname())

aom_map_base = {}


aom_biomes = {}
aom_biomes.registered = {}

function aom_biomes.register_biome(biome, groups)
    -- aom_biomes[biome.name] = groups
    table.insert(aom_biomes.registered, biome.name)
    minetest.register_biome(biome)
    for _, group in pairs(groups) do
        if not aom_biomes[group] then
            aom_biomes[group] = {biome.name}
        else
            aom_biomes[group][#aom_biomes[group]+1] = biome.name
        end
    end

    if biome.y_min_ocean and (not biome.__has_reg) then
        biome.__has_reg = true
        biome.y_max = biome.y_min - 1
        biome.y_min = biome.y_min_ocean
        biome.name = biome.name.."_OCEAN"
        biome.node_top = biome.node_riverbed
        biome.vertical_blend = biome.ocean_vertical_blend or 0
        aom_biomes.register_biome(biome, groups)
    end
end


dofile(mod_path .. "/structure_spawning" .. "/cabins.lua")
dofile(mod_path .. "/structure_spawning" .. "/ruins.lua")
dofile(mod_path .. "/structure_spawning" .. "/boulders.lua")

dofile(mod_path .. "/aliases.lua")
dofile(mod_path .. "/biomes.lua")
dofile(mod_path .. "/ores" .. "/soil_types.lua")
dofile(mod_path .. "/ores.lua")


minetest.register_chatcommand("biome", {
        params = "",
        description = S("Tells the biome"),
        privs = {},
        func = function(name, param)
                local player = minetest.get_player_by_name(name)
                local p = player:get_pos()
                local b = minetest.get_biome_data(p)
                if not b then return false, S("No biome") end
                return true, S("Biome: "..minetest.get_biome_name(b.biome).."    Heat: "..b.heat.."    Humid: "..b.humidity)
        end
})

local function is_ocean(name)
    local l = string.len(name)
    if string.sub(name, l-5, l) == "_OCEAN" then
        return true
    end
end

minetest.register_chatcommand("biomelistoutput", {
    params = "",
    description = S("Tells the biome"),
    privs = {give=true},
    func = function(name, param)
        local str = "["
        local len = 0
        for bname, def in pairs(minetest.registered_biomes) do
            if not is_ocean(bname) then
                len = len +1
            end
        end
        local i = 0
        for bname, def in pairs(minetest.registered_biomes) do
            if not is_ocean(bname) then
                i = i + 1
                local t = (
                    '{"name": "'..bname..'",'..
                    '"heat_point": '..def.heat_point..','..
                    '"humidity_point": '..def.humidity_point..
                    ',"y_min": '..def.y_min..''..
                    ',"y_max": '..(def.y_max+100)..''..
                    '}'
                )
                if i<len then t = t .. ',' end
                str = str..t
            end
        end
        str = str .. "]"
        local filepath = minetest.get_worldpath().."/debugoutput.txt"
        local file = io.open(filepath, "w")
        if file then
            file:write(str)
        end
    end,
})

