local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local furnace_size = {
    type = "fixed",
    fixed = {-8/16, -8/16, -8/16, 8/16, 8/16, 8/16},}

local function do_effects(pos)
    for i=0, 4 do
        minetest.add_particle({
            pos = vector.offset(pos, math.random()-0.5, math.random(), math.random()-0.5),
            velocity = vector.new(0,math.random(),0),
            expirationtime = math.random() * 4,
            size = math.random() * 8,
            collisiondetection = false,
            vertical = false,
            texture = "aom_cooking_particle_finished_cooking.png^[colorize:#44444400:100",
            glow = 14,
        })
        minetest.add_particle({
            pos = vector.offset(pos, math.random()-0.5, math.random(), math.random()-0.5),
            velocity = vector.new(0,math.random()*3,0),
            expirationtime = math.random() * 1,
            size = math.random()+0.1,
            collisiondetection = false,
            vertical = false,
            texture = "aom_cooking_particle_finished_cooking.png^[colorize:#ffee8855:200",
            glow = 14,
        })
    end
end

minetest.register_node("aom_cooking:furnace", {
    description = S("Furnace"),
    _tt_long_desc = S("Can provide heat to crucibles."),
    _tt_how_to_use = S("[place] with a fuel item in hand"),
    groups = { item_furnace = 1, solid = 1, furniture = 1, suffocates = 1, oddly_breakable_by_hand = 3, cracky = 2, },
    drawtype = "mesh",
    use_texture_alpha = "opaque",
    tiles = {
        {
            name = "aom_furnace.png^[colorize:#222222:40" -- make the base not as glowy
        },
        {
            name = "aom_furnace_fire_off.png", -- this is the flame texture
        },
    },
    mesh = "aom_furnace.b3d",
    sounds = (aom_sounds and aom_sounds.default_stone()) or {},
    _custom_sounds = {
        passive = {
            name = "aom_furnace_fire_cc0",
            max_hear_distance = 5,
            gain = 0.7,
        },
    },
    collision_box = furnace_size,
    selection_box = furnace_size,
    on_rightclick = aom_cooking.activate_burner,
    paramtype = "light",
    paramtype2 = "facedir",
    on_place = function(itemstack, placer, pointed_thing)
        return minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
    end,
    _on_input_item = function(pos, itemstack)
        return aom_cooking.activate_burner(pos, nil, nil, itemstack, nil)
    end,
})

minetest.register_node("aom_cooking:furnace_active", {
    description = S("A pit for fires. Wait how are you carrying around a burning fireplace in your pocket?"),
    groups = { item_furnace = 1, solid = 1, suffocates = 1, oddly_breakable_by_hand = 3,
        not_in_creative_inventory = 1, melter = 1, cooker_sound = 1, cracky = 2, },
    drawtype = "mesh",
    use_texture_alpha = "opaque",
    tiles = {
        {
            name = "aom_furnace.png^[colorize:#222222:40" -- make the base not as glowy
        },
        {
            name = "aom_furnace_fire_on.png", -- this is the flame texture
            animation = {
                type = "vertical_frames",
                aspect_w = 8,
                aspect_h = 14,
                length = 1,
            },
        },
    },
    drop = "aom_cooking:furnace",
    mesh = "aom_furnace.b3d",
    light_source = 12,
    paramtype = "light",
    sounds = (aom_sounds and aom_sounds.default_stone()) or {},
    _fuel_use = 2,
    _custom_sounds = {
        passive = {
            name = "aom_furnace_fire_cc0",
            max_hear_distance = 5,
            gain = 0.7,
        },
    },
    collision_box = furnace_size,
    selection_box = furnace_size,
    paramtype2 = "facedir",
    on_timer = function(pos, elapsed)
        do_effects(pos)
        aom_cooking.do_node_sound(pos, "passive")
        local ret = aom_cooking.burner_on_timer(pos, elapsed)
        return ret or true
    end,
    on_construct = function(pos)
        minetest.get_node_timer(pos):start(1)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        aom_cooking.activate_burner(pos, node, clicker, itemstack, pointed_thing)
    end,
    on_destruct = function(pos)
        aom_cooking.stop_node_sound(pos)
    end,
    _on_input_item = function(pos, itemstack)
        return aom_cooking.activate_burner(pos, nil, nil, itemstack, nil)
    end,
})




if true then
    local s = "aom_stone:cobble"
    minetest.register_craft({
        output = "aom_cooking:furnace",
        recipe = {
            {s,  s, s},
            {s, "", s},
            {s,  s, s},
        },
    })
end

