
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'ash_forest_dense'

aom_biomes.register_biome({
    name = this_biome,

    node_top = 'aom_soil:forest_grass_2',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 120,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,

    vertical_blend = 1,

    heat_point = 83,
    humidity_point = 51,
}, {"forest", "ash", "overworld", "mushrooms_dense", "grass"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path


-- FOREST GRASS
local size = 20
local off = 0
local sca = 300


minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_stone:stone",
    wherein		= {"aom_soil:forest_grass_2"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
            offset = sealevel+10,
            scale = 200,
            spread = {x = size, y = size, z = size},
            seed = 438,
            octaves = 2,
    },
    np_stratum_thickness = {
            offset = off,
            scale = sca/2,
            spread = {x = 10, y = 10, z = 10},
            seed = 654,
            octaves = 2,
            persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})

minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_soil:forest_grass_1",
    wherein		= {"aom_soil:forest_grass_2"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
            offset = sealevel+10,
            scale = 200,
            spread = {x = size, y = size, z = size},
            seed = 5643,
            octaves = 2,
    },
    np_stratum_thickness = {
            offset = off,
            scale = sca,
            spread = {x = 10, y = 10, z = 10},
            seed = 900786,
            octaves = 2,
            persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_soil:forest_dirt",
    wherein		= {"aom_soil:forest_grass_1"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
            offset = sealevel+10,
            scale = 200,
            spread = {x = size, y = size, z = size},
            seed = 5643,
            octaves = 2,
    },
    np_stratum_thickness = {
            offset = off - 20,
            scale = sca - 90,
            spread = {x = 10, y = 10, z = 10},
            seed = 900786,
            octaves = 3,
            persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})

minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_soil:forest_grass",
    wherein		= {"aom_soil:forest_dirt"},
    clust_scarcity	= 200,
    clust_num_ores	= 6,
    clust_size	= 5,
    noise_params = {
        offset = -0.05,
        scale = 1,
        spread = {x = 80, y = 80, z = 80},
        seed = 64758,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    biomes = {this_biome},
})

size = 30
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_soil:grass",
    wherein		= {"group:topsoil"},
    y_max = alt_max,
    y_min = sealevel,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 100,
        spread = {x = size, y = size, z = size},
        seed = 765,
        octaves = 2,
        lacunarity = 2.3,
    },
    np_stratum_thickness = {
        offset = -20,
        scale = 190,
        spread = {x = 20, y = 20, z = 20},
        seed = 987,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.3,
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})


if true then
-- HUGE ASH
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.004,
        scale = 0.004,
        spread = {x = 10, y = 10, z = 10},
        seed = 4535,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_huge_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
-- GIANT ash
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.009,
        scale = 0.009,
        spread = {x = 10, y = 10, z = 10},
        seed = 64758,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    fill_ratio = 0.02,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_3"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.006,
        scale = 0.005,
        spread = {x = 10, y = 10, z = 10},
        seed = 543,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.009,
        scale = 0.009,
        spread = {x = 10, y = 10, z = 10},
        seed = 765,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.006,
        scale = 0.007,
        spread = {x = 10, y = 10, z = 10},
        seed = 64758,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_3"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- oaks
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
})



minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:dirt_with_grass"},
    sidelen = 80,
    fill_ratio = 0.006,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:dirt_with_grass"},
    sidelen = 80,
    fill_ratio = 0.006,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_bush_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0,
})

end


