
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

---@param num number (0 -> 3)
local function do_grass_stuff(num, seed, biomes)
    minetest.register_decoration({
        deco_type = "simple",
        place_on = {"aom_soil:grass"},
        sidelen = 4,
        noise_params = {
            offset = 0.1,
            scale = 0.4,
            spread = {x = 4, y = 8, z = 4},
            seed = seed,
            octaves = 1,
            persist = 0.2
        },
        biomes = biomes or aom_biomes.registered.grass or {"grasslands"},
        y_max = alt_max,
        y_min = sealevel,
        decoration = "aom_flora:grass_"..num,
    })
end

do_grass_stuff(0, 6546)
do_grass_stuff(1, 6546)
do_grass_stuff(2, 6546)
do_grass_stuff(3, 6546)

aom_biomes.add_grass = do_grass_stuff
